/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.metric.VariableOrFieldMetric;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class MethodLevelFieldUsageCount
implements CKASTVisitor,
MethodLevelMetric,
VariableOrFieldMetric {
    private Set<String> declaredFields = new HashSet<String>();
    private Map<String, Integer> occurrences = new HashMap<String, Integer>();
    private Set<String> variables = new HashSet<String>();
    private boolean isFieldAccess;
    private boolean isQualifiedName;

    @Override
    public void visit(MethodDeclaration node) {
        IVariableBinding[] fields;
        IMethodBinding binding = node.resolveBinding();
        if (binding == null) {
            return;
        }
        for (IVariableBinding field : fields = binding.getDeclaringClass().getDeclaredFields()) {
            this.declaredFields.add(field.getName());
        }
    }

    @Override
    public void visit(VariableDeclarationFragment node) {
        String var = node.getName().toString();
        this.variables.add(var);
    }

    @Override
    public void visit(FieldAccess node) {
        this.isFieldAccess = true;
    }

    @Override
    public void endVisit(FieldAccess node) {
        this.isFieldAccess = false;
    }

    @Override
    public void visit(QualifiedName node) {
        this.isQualifiedName = true;
    }

    @Override
    public void endVisit(QualifiedName node) {
        this.isQualifiedName = false;
    }

    private void plusOne(String var) {
        if (!this.occurrences.containsKey(var)) {
            this.occurrences.put(var, 0);
        }
        this.occurrences.put(var, this.occurrences.get(var) + 1);
    }

    @Override
    public void visit(SimpleName node) {
        boolean accessFieldUsingOnlyVariableName;
        String variableName = node.getIdentifier();
        boolean accessFieldUsingThis = this.isFieldAccess && this.declaredFields.contains(variableName);
        boolean bl = accessFieldUsingOnlyVariableName = !this.isFieldAccess && this.declaredFields.contains(variableName) && !this.variables.contains(variableName);
        if ((accessFieldUsingThis || accessFieldUsingOnlyVariableName) && !this.isQualifiedName) {
            this.plusOne(variableName);
        }
    }

    @Override
    public void setResult(CKMethodResult result) {
        result.setFieldUsage(this.occurrences);
    }
}

