/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class NumberOfInnerClassesLambdasAndAnonymousClasses
implements CKASTVisitor,
ClassLevelMetric,
MethodLevelMetric {
    private int anonymousClassesQty = 0;
    private int innerClassesQty = 0;
    private int lambdasQty = 0;
    private String firstFound = null;

    @Override
    public void visit(TypeDeclaration node) {
        if (this.firstFound == null) {
            this.firstFound = "type";
        }
        ++this.innerClassesQty;
    }

    @Override
    public void visit(EnumDeclaration node) {
        ++this.innerClassesQty;
        if (this.firstFound == null) {
            this.firstFound = "enum";
        }
    }

    @Override
    public void visit(LambdaExpression node) {
        ++this.lambdasQty;
        if (this.firstFound == null) {
            this.firstFound = "lambda";
        }
    }

    @Override
    public void visit(AnonymousClassDeclaration node) {
        ++this.anonymousClassesQty;
        if (this.firstFound == null) {
            this.firstFound = "anonymous";
        }
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setAnonymousClassesQty(this.anonymousClassesQty - (this.firstFound.equals("anonymous") ? 1 : 0));
        result.setInnerClassesQty(this.innerClassesQty - (this.firstFound.equals("type") || this.firstFound.equals("enum") ? 1 : 0));
        result.setLambdasQty(this.lambdasQty - (this.firstFound.equals("lambda") ? 1 : 0));
    }

    @Override
    public void setResult(CKMethodResult result) {
        result.setAnonymousClassesQty(this.anonymousClassesQty);
        result.setInnerClassesQty(this.innerClassesQty);
        result.setLambdasQty(this.lambdasQty);
    }
}

