/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public class NumberOfMaxNestedBlock
implements CKASTVisitor,
ClassLevelMetric,
MethodLevelMetric {
    private int current = 0;
    private int max = 0;
    private Stack<ASTNode> currentNode = new Stack();
    private Stack<Boolean> blocks = new Stack();
    private Stack<Boolean> nodes = new Stack();

    @Override
    public void visit(Block node) {
        if (this.currentNode.empty() || !(this.currentNode.peek() instanceof SwitchCase)) {
            this.plusOne();
            this.blocks.push(true);
        } else {
            this.blocks.push(false);
        }
        this.currentNode.push((ASTNode)node);
    }

    @Override
    public void visit(ForStatement node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock(node.getBody());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void visit(EnhancedForStatement node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock(node.getBody());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void visit(DoStatement node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock(node.getBody());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void visit(WhileStatement node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock(node.getBody());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void visit(SwitchStatement node) {
        this.currentNode.push((ASTNode)node);
        this.nodes.push(true);
        this.plusOne();
    }

    @Override
    public void visit(SwitchCase node) {
        this.currentNode.push((ASTNode)node);
    }

    @Override
    public void visit(CatchClause node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock((Statement)node.getBody());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void visit(IfStatement node) {
        this.currentNode.push((ASTNode)node);
        boolean containsBlock = this.containsBlock(node.getThenStatement());
        if (!containsBlock) {
            this.plusOne();
            this.nodes.push(true);
        } else {
            this.nodes.push(false);
        }
    }

    @Override
    public void endVisit(Block node) {
        Boolean pop = this.blocks.pop();
        if (pop.booleanValue()) {
            --this.current;
        }
        this.currentNode.pop();
    }

    @Override
    public void endVisit(IfStatement node) {
        this.popBlock();
    }

    private boolean containsBlock(Statement body) {
        return body instanceof Block;
    }

    private void plusOne() {
        ++this.current;
        this.max = Math.max(this.current, this.max);
    }

    private void popBlock() {
        Boolean pop = this.nodes.pop();
        if (pop.booleanValue()) {
            --this.current;
        }
    }

    @Override
    public void endVisit(CatchClause node) {
        this.popBlock();
    }

    @Override
    public void endVisit(WhileStatement node) {
        this.popBlock();
    }

    @Override
    public void endVisit(DoStatement node) {
        this.popBlock();
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        this.popBlock();
    }

    @Override
    public void endVisit(ForStatement node) {
        this.popBlock();
    }

    @Override
    public void endVisit(SwitchStatement node) {
        this.popBlock();
    }

    @Override
    public void setResult(CKMethodResult result) {
        result.setMaxNestedBlocks(Math.max(0, this.max - 1));
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setMaxNestedBlocks(Math.max(0, this.max - 1));
    }
}

