/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.metric.VariableOrFieldMetric;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class VariableOrParameterUsageCount
implements CKASTVisitor,
MethodLevelMetric,
VariableOrFieldMetric {
    private Set<String> declaredVariables = new HashSet<String>();
    private Map<String, Integer> occurrences = new HashMap<String, Integer>();

    @Override
    public void setResult(CKMethodResult result) {
        result.setVariablesUsage(this.occurrences);
    }

    @Override
    public void visit(VariableDeclarationFragment node) {
        this.declaredVariables.add(node.getName().toString());
    }

    @Override
    public void visit(SingleVariableDeclaration node) {
        this.declaredVariables.add(node.getName().toString());
    }

    @Override
    public void visit(SimpleName node) {
        if (this.declaredVariables.contains(node.toString())) {
            String var = node.getIdentifier();
            if (!this.occurrences.containsKey(var)) {
                this.occurrences.put(var, -1);
            }
            this.occurrences.put(var, this.occurrences.get(var) + 1);
        }
    }
}

