/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.WhileStatement;

public class WMC
implements CKASTVisitor,
ClassLevelMetric,
MethodLevelMetric {
    protected int cc = 0;
    private LinkedList<ASTNode> stack = new LinkedList();

    @Override
    public void visit(MethodDeclaration node) {
        this.increaseCc();
    }

    @Override
    public void visit(ForStatement node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(EnhancedForStatement node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(ConditionalExpression node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(DoStatement node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(WhileStatement node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(SwitchCase node) {
        if (!node.isDefault()) {
            this.increaseCCFromExpression(node.getExpression());
        }
        this.stack.push((ASTNode)node);
    }

    @Override
    public void visit(InfixExpression node) {
        HashSet<InfixExpression.Operator> operatorsToConsider;
        if (this.stack.isEmpty() && (operatorsToConsider = new HashSet<InfixExpression.Operator>(){
            {
                this.add(InfixExpression.Operator.LESS);
                this.add(InfixExpression.Operator.GREATER);
                this.add(InfixExpression.Operator.LESS_EQUALS);
                this.add(InfixExpression.Operator.GREATER_EQUALS);
                this.add(InfixExpression.Operator.EQUALS);
                this.add(InfixExpression.Operator.NOT_EQUALS);
            }
        }).contains(node.getOperator())) {
            this.increaseCc();
        }
    }

    @Override
    public void visit(Initializer node) {
        this.increaseCc();
    }

    @Override
    public void visit(CatchClause node) {
        this.increaseCc();
    }

    @Override
    public void visit(IfStatement node) {
        this.increaseCCFromExpression(node.getExpression());
        this.stack.push((ASTNode)node);
    }

    @Override
    public void endVisit(ForStatement node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(ConditionalExpression node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(DoStatement node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(WhileStatement node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(SwitchCase node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(IfStatement node) {
        this.stack.pop();
    }

    @Override
    public void endVisit(MethodDeclaration node) {
        this.stack.clear();
    }

    private int increaseCCFromExpression(Expression expression) {
        if (expression == null) {
            this.increaseCc();
            return 0;
        }
        if (!this.containsIfTenary(expression)) {
            this.increaseCc();
        }
        String expr = expression.toString().replace("&&", "&").replace("||", "|");
        int ands = StringUtils.countMatches((CharSequence)expr, (CharSequence)"&");
        int ors = StringUtils.countMatches((CharSequence)expr, (CharSequence)"|");
        this.increaseCc(ands + ors);
        return ands + ors;
    }

    private boolean containsIfTenary(Expression expression) {
        if (expression instanceof ParenthesizedExpression) {
            ParenthesizedExpression x = (ParenthesizedExpression)expression;
            return this.containsIfTenary(x.getExpression());
        }
        if (expression instanceof InfixExpression) {
            InfixExpression x = (InfixExpression)expression;
            return this.containsIfTenary(x.getLeftOperand()) || this.containsIfTenary(x.getRightOperand());
        }
        return expression instanceof ConditionalExpression;
    }

    private void increaseCc() {
        this.increaseCc(1);
    }

    protected void increaseCc(int qtd) {
        this.cc += qtd;
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setWmc(this.cc);
    }

    @Override
    public void setResult(CKMethodResult result) {
        result.setWmc(this.cc);
    }
}

