/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import com.github.mauricioaniche.ck.metric.RunAfter;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class DependencySorter {
    public <T> List<Class<? extends T>> sort(List<Class<? extends T>> toSort) {
        Stack<Integer> sortedStack = new Stack<Integer>();
        boolean[][] adjacencyMatrix = this.deriveAdjacencyMatrix(toSort);
        boolean[] visited = new boolean[toSort.size()];
        for (int i2 = 0; i2 < toSort.size(); ++i2) {
            if (visited[i2]) continue;
            this.topologicalSort(i2, visited, adjacencyMatrix, sortedStack);
        }
        return sortedStack.stream().map(i -> (Class)toSort.get((int)i)).collect(Collectors.toList());
    }

    private void topologicalSort(int v, boolean[] visited, boolean[][] adjacencyMatrix, Stack<Integer> sortedStack) {
        visited[v] = true;
        IntStream.range(0, adjacencyMatrix[v].length).filter(i -> adjacencyMatrix[v][i]).filter(i -> !visited[i]).forEach(i -> this.topologicalSort(i, visited, adjacencyMatrix, sortedStack));
        sortedStack.push(v);
    }

    private <T> boolean[][] deriveAdjacencyMatrix(List<Class<? extends T>> toSort) {
        boolean[][] adjacencyMatrix = new boolean[toSort.size()][toSort.size()];
        IntStream.range(0, toSort.size()).filter(i -> ((Class)toSort.get(i)).getAnnotation(RunAfter.class) != null).mapToObj(i -> Pair.of((Object)i, ((Class)toSort.get(i)).getAnnotation(RunAfter.class).metrics())).flatMap(p -> Arrays.stream((Class[])p.getValue()).map(d -> Pair.of((Object)((Integer)p.getKey()), (Object)toSort.indexOf(d))).filter(d -> (Integer)d.getValue() != -1)).forEach(p -> {
            adjacencyMatrix[((Integer)p.getKey()).intValue()][((Integer)p.getValue()).intValue()] = true;
        });
        return adjacencyMatrix;
    }
}

