/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileUtils {
    public static final List<String> IGNORED_DIRECTORIES = new ArrayList<String>();

    public static String[] getAllDirs(String path) {
        try {
            return (String[])Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(FileUtils::isHiddenDir).filter(x -> !FileUtils.isIgnoredDir(x.toAbsolutePath().toString(), IGNORED_DIRECTORIES)).map(x -> x.toAbsolutePath().toString()).toArray(String[]::new);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getAllJavaFiles(String path) {
        return FileUtils.getAllFiles(path, "java");
    }

    public static String[] getAllJars(String path) {
        return FileUtils.getAllFiles(path, "jar");
    }

    private static String[] getAllFiles(String path, String ending) {
        try {
            return (String[])Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> !FileUtils.isIgnoredDir(x.toAbsolutePath().toString(), IGNORED_DIRECTORIES)).filter(x -> x.toAbsolutePath().toString().toLowerCase().endsWith(ending)).map(x -> x.toAbsolutePath().toString()).toArray(String[]::new);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isHiddenDir(Path path) {
        try {
            return Files.isHidden(path);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isIgnoredDir(String path, Collection<String> blocked) {
        for (String ignoredDirectory : blocked) {
            if (!path.contains(ignoredDirectory)) continue;
            return true;
        }
        return false;
    }

    static {
        IGNORED_DIRECTORIES.add(String.format("%c.git%c", Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar)));
    }
}

