/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class LOCCalculator {
    private static Logger log = Logger.getLogger(LOCCalculator.class);

    public static int calculate(String sourceCode) {
        try {
            InputStream is = IOUtils.toInputStream((String)sourceCode);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return LOCCalculator.getNumberOfLines(reader);
        }
        catch (IOException e) {
            log.error((Object)"Error when counting lines", (Throwable)e);
            return 0;
        }
    }

    private static int getNumberOfLines(BufferedReader bReader) throws IOException {
        int count = 0;
        boolean commentBegan = false;
        String line = null;
        while ((line = bReader.readLine()) != null) {
            if ("".equals(line = line.trim()) || line.startsWith("//")) continue;
            if (commentBegan) {
                if (!LOCCalculator.commentEnded(line)) continue;
                line = line.substring(line.indexOf("*/") + 2).trim();
                commentBegan = false;
                if ("".equals(line) || line.startsWith("//")) continue;
            }
            if (LOCCalculator.isSourceCodeLine(line)) {
                ++count;
            }
            if (!LOCCalculator.commentBegan(line)) continue;
            commentBegan = true;
        }
        return count;
    }

    private static boolean commentBegan(String line) {
        int index = line.indexOf("/*");
        if (index < 0) {
            return false;
        }
        int quoteStartIndex = line.indexOf("\"");
        if (quoteStartIndex != -1 && quoteStartIndex < index) {
            while (quoteStartIndex > -1) {
                line = line.substring(quoteStartIndex + 1);
                int quoteEndIndex = line.indexOf("\"");
                line = line.substring(quoteEndIndex + 1);
                quoteStartIndex = line.indexOf("\"");
            }
            return LOCCalculator.commentBegan(line);
        }
        return !LOCCalculator.commentEnded(line.substring(index + 2));
    }

    private static boolean commentEnded(String line) {
        int index = line.indexOf("*/");
        if (index < 0) {
            return false;
        }
        String subString = line.substring(index + 2).trim();
        if ("".equals(subString) || subString.startsWith("//")) {
            return true;
        }
        return !LOCCalculator.commentBegan(subString);
    }

    private static boolean isSourceCodeLine(String line) {
        boolean isSourceCodeLine = false;
        if ("".equals(line = line.trim()) || line.startsWith("//")) {
            return isSourceCodeLine;
        }
        if (line.length() == 1) {
            return true;
        }
        int index = line.indexOf("/*");
        if (index != 0) {
            return true;
        }
        while (line.length() > 0) {
            int endCommentPosition = (line = line.substring(index + 2)).indexOf("*/");
            if (endCommentPosition < 0) {
                return false;
            }
            if (endCommentPosition == line.length() - 2) {
                return false;
            }
            String subString = line.substring(endCommentPosition + 2).trim();
            if ("".equals(subString) || subString.indexOf("//") == 0) {
                return false;
            }
            if (subString.startsWith("/*")) {
                line = subString;
                continue;
            }
            return true;
        }
        return isSourceCodeLine;
    }
}

