/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint;

import com.github.mauricioaniche.springlint.RunAllAnalysis;
import com.github.mauricioaniche.springlint.architecture.Architecture;
import com.github.mauricioaniche.springlint.architecture.SpringMVCArchitecture;
import com.github.mauricioaniche.springlint.output.CSVOutput;
import com.github.mauricioaniche.springlint.output.HTMLOutput;
import com.github.mauricioaniche.springlint.output.Output;
import java.io.FileNotFoundException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="springlint", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SpringLintMojo
extends AbstractMojo {
    @Parameter(defaultValue="./", property="outputDir", required=true)
    private String outputPath;
    @Parameter(defaultValue="html", property="format", required=true)
    private String format;

    public void execute() throws MojoExecutionException {
        SpringMVCArchitecture arch = new SpringMVCArchitecture();
        String projectPath = ".";
        try {
            Object output = this.format.equals("html") ? new HTMLOutput(this.outputPath) : new CSVOutput(this.outputPath);
            new RunAllAnalysis((Architecture)arch, projectPath, (Output)output).run();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

