/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.ck;

import br.com.aniche.ck.CK;
import br.com.aniche.ck.CKNumber;
import br.com.aniche.ck.CKReport;
import com.github.mauricioaniche.springlint.architecture.ArchitecturalRole;
import com.github.mauricioaniche.springlint.architecture.Architecture;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CKAnalysis {
    private String projectPath;
    private Map<String, List<CKNumber>> result;
    private Architecture arch;

    public CKAnalysis(Architecture arch, String projectPath) {
        this.arch = arch;
        this.projectPath = projectPath;
        this.result = new HashMap<String, List<CKNumber>>();
    }

    public Map<String, List<CKNumber>> run() throws FileNotFoundException {
        CKReport report = new CK().plug(() -> this.arch.roleVisitor()).calculate(this.projectPath);
        for (ArchitecturalRole role : this.rolesPlusUnindentified()) {
            List filtered = report.all().stream().filter(n -> n.getSpecific("role") == role.id()).collect(Collectors.toList());
            this.result.put(role.name().toLowerCase(), filtered);
        }
        return this.result;
    }

    private List<ArchitecturalRole> rolesPlusUnindentified() {
        ArrayList<ArchitecturalRole> roles = new ArrayList<ArchitecturalRole>(this.arch.roles());
        roles.add(ArchitecturalRole.OTHER);
        return roles;
    }
}

