/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import com.github.mauricioaniche.springlint.architecture.ArchitecturalRole;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;

public class ArchitecturalRoleDependenciesCountVisitor
extends ASTVisitor {
    private SmellyClass clazz;
    private Repository repo;
    private Set<String> roles;
    private ArchitecturalRole ar;
    private String attributeName;

    public ArchitecturalRoleDependenciesCountVisitor(Repository repo, SmellyClass clazz, ArchitecturalRole ar, String attributeName) {
        this.repo = repo;
        this.clazz = clazz;
        this.ar = ar;
        this.attributeName = attributeName;
        this.roles = new HashSet<String>();
        clazz.setAttribute(attributeName, 0);
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding != null && binding instanceof ITypeBinding) {
            boolean notMySelf;
            ITypeBinding tb = (ITypeBinding)binding;
            String className = tb.getQualifiedName();
            SmellyClass possibleRole = this.getPossibleRole(tb);
            boolean bl = notMySelf = possibleRole != null && !possibleRole.equals(this.clazz);
            if (possibleRole != null && possibleRole.is(this.ar) && notMySelf) {
                this.clazz.appendNote(this.attributeName + "-violations", className);
                this.roles.add(className);
                this.clazz.setAttribute(this.attributeName, this.roles.size());
            }
        }
        return super.visit(node);
    }

    private SmellyClass getPossibleRole(ITypeBinding tb) {
        SmellyClass possibleService;
        String className = tb.getQualifiedName();
        if (tb.isInterface()) {
            List<SmellyClass> subtypes = this.repo.getSubtypesOf(className);
            possibleService = this.findRole(subtypes);
        } else {
            possibleService = this.repo.getByClass(className);
        }
        return possibleService;
    }

    private SmellyClass findRole(List<SmellyClass> subtypes) {
        Optional<SmellyClass> sc = subtypes.stream().filter(s -> s.is(this.ar)).findFirst();
        return sc.orElse(null);
    }
}

