/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import com.github.mauricioaniche.springlint.architecture.ArchitecturalRoleVisitor;
import com.github.mauricioaniche.springlint.architecture.Architecture;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import com.github.mauricioaniche.springlint.utils.jdt.ClassInfoVisitor;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class ArchitecturalRoleRequestor
extends FileASTRequestor {
    private Repository repo;
    private static Logger log = Logger.getLogger(ArchitecturalRoleRequestor.class);
    private Architecture arch;

    public ArchitecturalRoleRequestor(Architecture arch, Repository repo) {
        this.arch = arch;
        this.repo = repo;
    }

    public void acceptAST(String sourceFilePath, CompilationUnit cu) {
        try {
            ClassInfoVisitor info = new ClassInfoVisitor();
            cu.accept((ASTVisitor)info);
            if (info.getClassName() == null) {
                return;
            }
            SmellyClass clazz = this.repo.add(sourceFilePath, info.getClassName(), info.getType(), info.getSuperclass(), info.getInterfaces());
            ArchitecturalRoleVisitor visitor = this.arch.roleVisitor();
            cu.accept((ASTVisitor)visitor);
            clazz.setRole(visitor.getRole());
            log.info((Object)String.format("-- %s is a %s (%s)", clazz.getName(), clazz.getRole(), clazz.getType()));
        }
        catch (Exception e) {
            log.error((Object)("error in " + sourceFilePath), (Throwable)e);
        }
    }
}

