/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import br.com.aniche.ck.FileUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class Parser {
    private static Logger log = Logger.getLogger(Parser.class);
    private static final int MAX_AT_ONCE;
    private List<List<String>> partitions;
    private String[] srcDirs;
    private String[] javaFiles;

    public Parser(String projectPath) {
        this.srcDirs = FileUtils.getAllDirs((String)projectPath);
        this.javaFiles = FileUtils.getAllJavaFiles((String)projectPath);
        this.partitions = Lists.partition(Arrays.asList(this.javaFiles), (int)MAX_AT_ONCE);
        log.info((Object)String.format("Found %d java files. We divided into %d partitions", this.javaFiles.length, this.partitions.size()));
    }

    public void execute(FileASTRequestor storage) {
        for (List<String> partition : this.partitions) {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"1.8", (Map)options);
            parser.setCompilerOptions((Map)options);
            parser.setEnvironment(null, this.srcDirs, null, true);
            parser.createASTs(partition.toArray(new String[partition.size()]), null, new String[0], storage, null);
        }
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        MAX_AT_ONCE = maxMemory >= 2000L ? 400 : (maxMemory >= 1500L ? 300 : (maxMemory >= 1000L ? 200 : (maxMemory >= 500L ? 100 : 25)));
    }
}

