/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import com.github.mauricioaniche.springlint.analysis.smells.ArchitecturalRoleRequestor;
import com.github.mauricioaniche.springlint.analysis.smells.Parser;
import com.github.mauricioaniche.springlint.analysis.smells.SmellsRequestor;
import com.github.mauricioaniche.springlint.architecture.Architecture;
import com.github.mauricioaniche.springlint.domain.Repository;
import org.apache.log4j.Logger;

public class SmellAnalysis {
    private String projectPath;
    private Repository repo;
    private Parser parser;
    private static Logger log = Logger.getLogger(SmellAnalysis.class);
    private Architecture arch;

    public SmellAnalysis(Architecture arch, String projectPath) {
        this.arch = arch;
        this.projectPath = projectPath;
        this.repo = new Repository();
    }

    public Repository run() {
        log.info((Object)"Starting the parse engine");
        this.parser = new Parser(this.projectPath);
        this.identifyRoles();
        this.searchSmells();
        return this.repo;
    }

    private void searchSmells() {
        log.info((Object)"Identifying smells...");
        this.parser.execute(new SmellsRequestor(this.repo, this.arch.smells()));
    }

    private void identifyRoles() {
        log.info((Object)"Identifying roles...");
        this.parser.execute(new ArchitecturalRoleRequestor(this.arch, this.repo));
    }
}

