/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import com.github.mauricioaniche.springlint.analysis.smells.Smell;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class SmellsRequestor
extends FileASTRequestor {
    private static Logger log = Logger.getLogger(SmellsRequestor.class);
    private Repository repo;
    private List<Smell> smells;

    public SmellsRequestor(Repository repo, List<Smell> smells) {
        this.repo = repo;
        this.smells = smells;
    }

    public void acceptAST(String sourceFilePath, CompilationUnit cu) {
        try {
            SmellyClass clazz = this.repo.get(sourceFilePath);
            log.info((Object)("Analysing class " + clazz.getName()));
            for (Smell smell : this.smells) {
                log.debug((Object)("-- Smell detector: " + smell.getClass().getSimpleName()));
                for (Callable<ASTVisitor> visitorInstantiator : smell.analyzers(this.repo, clazz)) {
                    ASTVisitor visitor = visitorInstantiator.call();
                    log.debug((Object)("--- Calculating " + visitor.getClass().getSimpleName()));
                    cu.accept(visitor);
                }
                boolean foundASmell = smell.conciliate(clazz);
                if (!foundASmell) continue;
                log.info((Object)"-- SMELL DETECTED!");
            }
        }
        catch (Throwable e) {
            log.error((Object)("error in " + sourceFilePath), e);
        }
    }
}

