/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class VariablesAndFieldsVisitor
extends ASTVisitor {
    protected Map<String, String> localVariables = new HashMap<String, String>();
    protected Map<String, String> fieldVariables = new HashMap<String, String>();
    protected Map<String, String> importList = new HashMap<String, String>();

    public boolean visit(ImportDeclaration node) {
        String importName = node.getName().toString();
        String[] splittedImportName = importName.split("\\.");
        String clazzName = splittedImportName[splittedImportName.length - 1];
        this.importList.put(clazzName, importName);
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        String simpleType = node.getType().toString();
        for (Object o : node.fragments()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)o;
            String variableName = fragment.getName().toString();
            String fullType = this.importList.containsKey(simpleType) ? this.importList.get(simpleType) : simpleType;
            this.fieldVariables.put(variableName, fullType);
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        String simpleType = node.getType().toString();
        for (Object o : node.fragments()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)o;
            String variableName = fragment.getName().toString();
            String fullType = this.importList.containsKey(simpleType) ? this.importList.get(simpleType) : simpleType;
            this.localVariables.put(variableName, fullType);
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        this.localVariables.clear();
        return super.visit(node);
    }

    protected String findType(MethodInvocation node) {
        String variableInvoked = node.getExpression().toString();
        String type = this.localVariables.containsKey(variableInvoked) ? this.localVariables.get(variableInvoked) : (this.fieldVariables.containsKey(variableInvoked) ? this.fieldVariables.get(variableInvoked) : "");
        return type;
    }
}

