/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.controller;

import com.github.mauricioaniche.springlint.analysis.smells.Smell;
import com.github.mauricioaniche.springlint.analysis.smells.controller.NumberOfRoutesVisitor;
import com.github.mauricioaniche.springlint.analysis.smells.controller.NumberOfServicesVisitor;
import com.github.mauricioaniche.springlint.architecture.SpringMVCArchitecture;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.core.dom.ASTVisitor;

public class PromiscuousController
implements Smell {
    private static final int ROUTES_THRESHOLD = 10;
    private static final int SERVICES_THRESHOLD = 3;

    @Override
    public List<Callable<ASTVisitor>> analyzers(Repository repo, SmellyClass clazz) {
        return Arrays.asList(() -> new NumberOfRoutesVisitor(clazz), () -> new NumberOfServicesVisitor(repo, clazz));
    }

    @Override
    public boolean conciliate(SmellyClass clazz) {
        boolean hasManyServices;
        int routes = clazz.getAttribute("number-of-routes");
        int services = clazz.getAttribute("number-of-services-as-dependencies");
        String listOfServices = clazz.getNote("number-of-services-as-dependencies-violations");
        boolean hasManyRoutes = routes > 10;
        boolean bl = hasManyServices = services > 3;
        if (clazz.is(SpringMVCArchitecture.CONTROLLER) && (hasManyRoutes || hasManyServices)) {
            clazz.smells("Promiscuous Controller", String.format("It has %d routes and %d services (%s)", routes, services, listOfServices));
            return true;
        }
        return false;
    }
}

