/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.controller;

import com.github.mauricioaniche.springlint.analysis.smells.VariablesAndFieldsVisitor;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.HashSet;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class RFCButSpringVisitor
extends VariablesAndFieldsVisitor {
    private HashSet<String> methodInvocations;
    private SmellyClass clazz;

    public RFCButSpringVisitor(SmellyClass clazz) {
        this.clazz = clazz;
        this.methodInvocations = new HashSet();
        this.update(clazz);
    }

    private void update(SmellyClass clazz) {
        clazz.setAttribute("rfc-but-spring", this.methodInvocations.size());
    }

    public boolean visit(MethodInvocation node) {
        boolean wasInvokedInADependency;
        boolean bl = wasInvokedInADependency = node.getExpression() != null;
        if (wasInvokedInADependency && !this.belongsToSpring(this.findType(node))) {
            this.methodInvocations.add(node.getName() + "/" + node.arguments().size());
        }
        this.update(this.clazz);
        return super.visit(node);
    }

    private boolean belongsToSpring(String type) {
        return type.contains(".springframework.");
    }
}

