/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.repository;

import com.github.mauricioaniche.springlint.analysis.smells.Smell;
import com.github.mauricioaniche.springlint.analysis.smells.repository.NumberOfEntitiesVisitor;
import com.github.mauricioaniche.springlint.architecture.SpringMVCArchitecture;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.core.dom.ASTVisitor;

public class FatRepository
implements Smell {
    private static final int ENTITY_THRESHOLD = 1;

    @Override
    public List<Callable<ASTVisitor>> analyzers(Repository repo, SmellyClass clazz) {
        return Arrays.asList(() -> new NumberOfEntitiesVisitor(repo, clazz));
    }

    @Override
    public boolean conciliate(SmellyClass clazz) {
        boolean hasHighEntities;
        int entities = clazz.getAttribute("number-of-entities-as-dependencies");
        String listOfEntities = clazz.getNote("number-of-entities-as-dependencies-violations");
        boolean bl = hasHighEntities = entities > 1;
        if (clazz.is(SpringMVCArchitecture.REPOSITORY) && hasHighEntities) {
            clazz.smells("Fat Repository", String.format("It depends upon %d entities (%s)", entities, listOfEntities));
            return true;
        }
        return false;
    }
}

