/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.repository;

import com.github.mauricioaniche.springlint.analysis.smells.VariablesAndFieldsVisitor;
import com.github.mauricioaniche.springlint.analysis.smells.repository.PersistenceAPIs;
import com.github.mauricioaniche.springlint.domain.SmellyClass;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class MultiplePersistenceInvocationsVisitor
extends VariablesAndFieldsVisitor {
    private SmellyClass clazz;
    private int qtyPerMethod = 0;

    public MultiplePersistenceInvocationsVisitor(SmellyClass clazz) {
        this.clazz = clazz;
        clazz.setAttribute("multiple-persistence-invocations", 0);
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        this.qtyPerMethod = 0;
        return super.visit(node);
    }

    public void endVisit(MethodDeclaration node) {
        if (this.qtyPerMethod > 1) {
            this.clazz.setAttribute("multiple-persistence-invocations", 1);
            this.saveMethodNameAsNote(node);
        }
        super.endVisit(node);
    }

    public boolean visit(MethodInvocation node) {
        boolean wasInvokedInADependency;
        boolean bl = wasInvokedInADependency = node.getExpression() != null;
        if (wasInvokedInADependency && PersistenceAPIs.isOnPersistenceMechanism(this.findType(node)) && PersistenceAPIs.isOnPersistenceMethod(node)) {
            ++this.qtyPerMethod;
        }
        return super.visit(node);
    }

    private void saveMethodNameAsNote(MethodDeclaration currentMethod) {
        String methodName = currentMethod.getName().toString();
        this.clazz.appendNote("multiple-persistence-invocations-violations", methodName);
    }
}

