/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.repository;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class PersistenceAPIs {
    private static Set<String> persistenceApis = new HashSet<String>();
    private static Set<String> persistenceMethods = new HashSet<String>();

    public static Set<String> getPersistenceApis() {
        return persistenceApis;
    }

    public static Set<String> getPersistenceMethods() {
        return persistenceMethods;
    }

    public static boolean isOnPersistenceMechanism(String type) {
        return persistenceApis.stream().anyMatch(api -> type.startsWith((String)api));
    }

    public static boolean isOnPersistenceMethod(MethodInvocation node) {
        String expr = node.toString();
        return persistenceMethods.stream().anyMatch(api -> expr.contains((CharSequence)api));
    }

    static {
        persistenceApis.add("org.springframework.data");
        persistenceMethods.add(".query");
        persistenceApis.add("org.hibernate");
        persistenceMethods.add(".createQuery");
        persistenceMethods.add(".createSQLQuery");
        persistenceMethods.add(".createFilter");
        persistenceMethods.add(".createNamedQuery");
        persistenceMethods.add(".createCriteria");
        persistenceApis.add("javax.persistence");
        persistenceMethods.add(".createNamedQuery");
        persistenceMethods.add(".createNativeQuery");
        persistenceMethods.add(".createQuery");
        persistenceMethods.add(".createStoredProcedure");
        persistenceMethods.add(".getCriteriaBuilder");
        persistenceApis.add("java.sql");
        persistenceMethods.add(".prepareStatement");
        persistenceMethods.add(".createStatement");
        persistenceMethods.add(".prepareCall");
    }
}

