/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.analysis.smells.repository;

import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.StringLiteral;

public class SQLComplexityVisitor
extends ASTVisitor {
    private SmellyClass clazz;
    private int complexity;
    private static Set<String> complexityKeywords = new HashSet<String>();

    public SQLComplexityVisitor(SmellyClass clazz) {
        this.clazz = clazz;
        this.complexity = 0;
        this.update();
    }

    public boolean visit(StringLiteral node) {
        String sql = node.getLiteralValue();
        if (this.isSql(sql)) {
            this.calculateComplexity(sql);
            this.update();
        }
        return super.visit(node);
    }

    private void update() {
        this.clazz.setAttribute("sql-complexity", this.complexity);
    }

    private void calculateComplexity(String sql) {
        sql = sql.toLowerCase();
        sql = sql.replace("(", " ");
        sql = sql.replace(")", " ");
        for (String keyword : complexityKeywords) {
            this.complexity += StringUtils.countMatches((CharSequence)sql, (CharSequence)keyword);
        }
    }

    private boolean isSql(String sql) {
        return true;
    }

    static {
        complexityKeywords.add("where");
        complexityKeywords.add("and");
        complexityKeywords.add("or");
        complexityKeywords.add("join");
        complexityKeywords.add("exists");
        complexityKeywords.add("not");
        complexityKeywords.add("from");
        complexityKeywords.add("xor");
        complexityKeywords.add("if");
        complexityKeywords.add("else");
        complexityKeywords.add("case");
        complexityKeywords.add(" in");
    }
}

