/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.architecture;

import br.com.aniche.ck.CKNumber;
import br.com.aniche.ck.CKReport;
import com.github.mauricioaniche.springlint.architecture.ArchitecturalRole;
import com.github.mauricioaniche.springlint.architecture.ArchitecturalRoleVisitor;
import com.github.mauricioaniche.springlint.architecture.SpringMVCArchitecture;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class SpringMVCArchitecturalRoleVisitor
extends ArchitecturalRoleVisitor {
    private Set<String> allAnnotations = new HashSet<String>();
    private int deep = 0;

    public boolean visit(TypeDeclaration node) {
        ++this.deep;
        return super.visit(node);
    }

    public void endVisit(TypeDeclaration node) {
        --this.deep;
    }

    public boolean visit(MarkerAnnotation node) {
        this.addAnnotation((Annotation)node);
        return super.visit(node);
    }

    public boolean visit(NormalAnnotation node) {
        this.addAnnotation((Annotation)node);
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.addAnnotation((Annotation)node);
        return super.visit(node);
    }

    private void addAnnotation(Annotation o) {
        if (this.deep > 1) {
            return;
        }
        String annotation = o.getTypeName().toString();
        this.allAnnotations.add(annotation);
    }

    @Override
    public ArchitecturalRole getRole() {
        for (String ann : this.allAnnotations) {
            if (ann.endsWith("Controller")) {
                return SpringMVCArchitecture.CONTROLLER;
            }
            if (ann.endsWith("Service")) {
                return SpringMVCArchitecture.SERVICE;
            }
            if (ann.endsWith("Entity")) {
                return SpringMVCArchitecture.ENTITY;
            }
            if (ann.endsWith("Repository")) {
                return SpringMVCArchitecture.REPOSITORY;
            }
            if (!ann.endsWith("Component")) continue;
            return SpringMVCArchitecture.COMPONENT;
        }
        return ArchitecturalRole.OTHER;
    }

    public void execute(CompilationUnit cu, CKReport report) {
        cu.accept((ASTVisitor)this);
    }

    public void setResult(CKNumber result) {
        result.addSpecific("role", this.getRole().id());
    }
}

