/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.domain;

import com.github.mauricioaniche.springlint.domain.SmellyClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Repository {
    private Map<String, SmellyClass> mapPerFile = new HashMap<String, SmellyClass>();
    private Map<String, SmellyClass> mapPerName = new HashMap<String, SmellyClass>();

    public SmellyClass get(String sourceFilePath) {
        return this.mapPerFile.get(sourceFilePath);
    }

    public SmellyClass add(String sourceFilePath, String className, String type, String superclass, Set<String> interfaces) {
        SmellyClass smellyClass = new SmellyClass(sourceFilePath, className, type, superclass, interfaces);
        this.mapPerFile.put(sourceFilePath, smellyClass);
        this.mapPerName.put(className, smellyClass);
        return this.get(sourceFilePath);
    }

    public Collection<SmellyClass> all() {
        return this.mapPerFile.values();
    }

    public SmellyClass getByClass(String qualifiedName) {
        return this.mapPerName.get(qualifiedName);
    }

    public List<SmellyClass> getSubtypesOf(String interfaceName) {
        ArrayList<SmellyClass> subtypes = new ArrayList<SmellyClass>();
        for (SmellyClass sc : this.mapPerName.values()) {
            if (!sc.getInterfaces().contains(interfaceName)) continue;
            subtypes.add(sc);
        }
        return subtypes;
    }
}

