/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.domain;

import com.github.mauricioaniche.springlint.analysis.smells.SmellDescription;
import com.github.mauricioaniche.springlint.architecture.ArchitecturalRole;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmellyClass {
    private final String file;
    private final String name;
    private final String type;
    private ArchitecturalRole role;
    private Set<SmellDescription> smells;
    private String superclass;
    private Set<String> interfaces;
    private Map<String, Integer> attributes;
    private Map<String, String> notes;

    public SmellyClass(String file, String name, String type, String superclass, Set<String> interfaces) {
        this.file = file;
        this.name = name;
        this.type = type;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.smells = new HashSet<SmellDescription>();
        this.role = ArchitecturalRole.OTHER;
        this.attributes = new HashMap<String, Integer>();
        this.notes = new HashMap<String, String>();
    }

    public void appendNote(String key, String note) {
        if (!this.notes.containsKey(key)) {
            this.notes.put(key, "");
        }
        this.notes.put(key, (this.notes.get(key) + " " + note).trim());
    }

    public String getNote(String key) {
        if (!this.notes.containsKey(key)) {
            return "";
        }
        return this.notes.get(key);
    }

    public String getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setRole(ArchitecturalRole role) {
        this.role = role;
    }

    public ArchitecturalRole getRole() {
        return this.role;
    }

    public void smells(String smell, String description) {
        this.smells.add(new SmellDescription(smell, description));
    }

    public boolean hasSmell(String smell) {
        return this.smells.stream().anyMatch(s -> s.getName().equals(smell));
    }

    public void setAttribute(String attribute, int value) {
        this.attributes.put(attribute, value);
    }

    public int getAttribute(String attribute) {
        if (!this.attributes.containsKey(attribute)) {
            return -1;
        }
        return this.attributes.get(attribute);
    }

    public boolean is(ArchitecturalRole role) {
        return this.role.equals(role);
    }

    public void plusOne(String attribute) {
        if (this.getAttribute(attribute) == -1) {
            this.setAttribute(attribute, 0);
        }
        this.setAttribute(attribute, this.getAttribute(attribute) + 1);
    }

    public String toString() {
        return "SmellyClass [file=" + this.file + ", name=" + this.name + ", type=" + this.type + ", role=" + this.role + ", smells=" + this.smells + ", attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmellyClass other = (SmellyClass)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.role == other.role;
    }

    public boolean hasAnySmell() {
        return !this.smells.isEmpty();
    }

    public String getDescriptionFor(String smell) {
        return this.smells.stream().filter(s -> s.getName().equals(smell)).findFirst().get().getDescription();
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<SmellDescription> getSmells() {
        return this.smells;
    }
}

