/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.output;

import br.com.aniche.ck.CKNumber;
import com.github.mauricioaniche.springlint.analysis.ck.CKAnalysis;
import com.github.mauricioaniche.springlint.architecture.Architecture;
import com.github.mauricioaniche.springlint.domain.Repository;
import com.github.mauricioaniche.springlint.output.Output;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HTMLOutput
implements Output {
    private PrintStream output;

    public HTMLOutput(String output) throws FileNotFoundException {
        this.output = new PrintStream(output + "result.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printOutput(Architecture arch, Map<String, List<CKNumber>> ckResults, Repository smellResults) {
        String ckResultsInJson = new Gson().toJson(ckResults);
        String smellResultsInJson = new Gson().toJson(smellResults.all());
        try {
            String html = this.readResource("/output/result.html");
            html = html.replace("##ck##", ckResultsInJson).replace("##smells##", smellResultsInJson).replace("##date##", new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
            this.output.print(html);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.output.close();
        }
    }

    private String readResource(String name) throws IOException {
        InputStream is = CKAnalysis.class.getResource(name).openStream();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer);
        String content = writer.toString();
        is.close();
        return content;
    }
}

