/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.springlint.utils.jdt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClassInfoVisitor
extends ASTVisitor {
    private String className;
    private String type;
    private String superclass;
    private Set<String> interfaces = new HashSet<String>();

    public boolean visit(TypeDeclaration node) {
        this.getFullClassName(node.resolveBinding());
        this.getType(node);
        this.getSuperclass(node);
        this.getInterfaces(node);
        return false;
    }

    private void getInterfaces(TypeDeclaration node) {
        if (node.superInterfaceTypes() != null) {
            for (Object o : node.superInterfaceTypes()) {
                String interfaceName = ((Type)o).resolveBinding().getBinaryName();
                this.interfaces.add(interfaceName);
            }
        }
    }

    private void getSuperclass(TypeDeclaration node) {
        if (node.getSuperclassType() != null) {
            this.superclass = node.getSuperclassType().resolveBinding().getBinaryName();
        }
    }

    private void getType(TypeDeclaration node) {
        this.type = node.isInterface() ? "interface" : "class";
    }

    public boolean visit(EnumDeclaration node) {
        this.type = "enum";
        this.getFullClassName(node.resolveBinding());
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getType() {
        return this.type;
    }

    private void getFullClassName(ITypeBinding binding) {
        if (binding != null) {
            this.className = binding.getBinaryName();
        }
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }
}

