/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compaq;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compaq.CompaqVisualFortranLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineFortranCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class CompaqVisualFortranCompiler
extends CommandLineFortranCompiler {
    private static final CompaqVisualFortranCompiler[] instance = new CompaqVisualFortranCompiler[]{new CompaqVisualFortranCompiler(false, null)};

    public static CompaqVisualFortranCompiler getInstance() {
        return instance[0];
    }

    private CompaqVisualFortranCompiler(boolean newEnvironment, Environment env) {
        super("DF", null, new String[]{".f90", ".for", ".f"}, new String[]{".i", ".i90", ".fpp", ".inc", ".bak", ".exe"}, ".obj", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("/nologo");
        args.addElement("/compile_only");
        if (debug) {
            args.addElement("/debug:full");
            args.addElement("/define:_DEBUG");
        } else {
            args.addElement("/debug:none");
            args.addElement("/define:NDEBUG");
        }
        if (multithreaded) {
            args.addElement("/threads");
            args.addElement("/define:_MT");
        } else {
            args.addElement("/nothreads");
        }
        boolean staticRuntime = linkType.isStaticRuntime();
        if (staticRuntime) {
            args.addElement("/libs:static");
        } else {
            args.addElement("/libs:dll");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/dll");
            args.addElement("/define:_DLL");
        }
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("/nowarn");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                args.addElement("/warn:usage");
                break;
            }
            case 4: {
                args.addElement("/warn:all");
                break;
            }
            case 5: {
                args.addElement("/warn:errors");
            }
        }
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new CompaqVisualFortranCompiler(newEnvironment, env);
        }
        return this;
    }

    protected void getDefineSwitch(StringBuffer buf, String define, String value) {
        buf.append("/define:");
        buf.append(define);
        if (value != null && value.length() > 0) {
            buf.append('=');
            buf.append(value);
        }
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    protected String getIncludeDirSwitch(String includeDir) {
        StringBuffer buf = new StringBuffer("/include:");
        buf.append(includeDir);
        return buf.toString();
    }

    public Linker getLinker(LinkType type) {
        return CompaqVisualFortranLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected void getUndefineSwitch(StringBuffer buf, String define) {
        buf.append("/undefine:");
        buf.append(define);
    }
}

