/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class CaptureStreamHandler
implements ExecuteStreamHandler {
    String[] output;
    private InputStream processErrorStream;
    private InputStream processOutputStream;

    public static String[] run(String[] cmdline) {
        CaptureStreamHandler handler = new CaptureStreamHandler();
        Execute exec = new Execute((ExecuteStreamHandler)handler);
        exec.setCommandline(cmdline);
        try {
            int status = exec.execute();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return handler.getOutput() != null ? handler.getOutput() : new String[]{};
    }

    public String[] getOutput() {
        return this.output;
    }

    public void gatherOutput() {
        try {
            Copier errorCopier = new Copier(this.processErrorStream);
            Copier outputCopier = new Copier(this.processOutputStream);
            errorCopier.start();
            outputCopier.start();
            errorCopier.join();
            outputCopier.join();
            if (errorCopier.getLines().size() > 0) {
                this.output = new String[errorCopier.getLines().size()];
                errorCopier.getLines().copyInto(this.output);
            } else {
                this.output = new String[outputCopier.getLines().size()];
                outputCopier.getLines().copyInto(this.output);
            }
        }
        catch (Exception e) {
            this.output = new String[0];
        }
    }

    public void setProcessErrorStream(InputStream is) throws IOException {
        this.processErrorStream = is;
    }

    public void setProcessInputStream(OutputStream os) throws IOException {
        os.close();
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.processOutputStream = is;
    }

    public void start() throws IOException {
        this.gatherOutput();
    }

    public void stop() {
    }

    static class Copier
    extends Thread {
        InputStream is;
        Vector lines;

        Copier(InputStream is) {
            this.is = is;
            this.lines = new Vector(10);
        }

        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                while ((line = reader.readLine()) != null) {
                    this.lines.addElement(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Vector getLines() {
            return this.lines;
        }
    }
}

