/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.gcc.GccProcessor;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.util.Vector;

public abstract class AbstractLdLinker
extends CommandLineLinker {
    private String outputPrefix;

    protected AbstractLdLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, AbstractLdLinker libtoolLinker) {
        super(command, identifierArg, extensions, ignoredExtensions, outputSuffix, isLibtool, libtoolLinker);
        this.outputPrefix = outputPrefix;
    }

    public void addBase(long base, Vector args) {
        if (base >= 0L) {
            args.addElement("--image-base");
            args.addElement(Long.toHexString(base));
        }
    }

    public void addFixed(Boolean fixed, Vector args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (debug) {
            args.addElement("-g");
        }
        if (this.isDarwin()) {
            if (linkType.isPluginModule()) {
                args.addElement("-bundle");
            } else if (linkType.isJNIModule()) {
                args.addElement("-dynamic");
                args.addElement("-bundle");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-dynamiclib");
            }
        } else {
            if (linkType.isStaticRuntime()) {
                args.addElement("-static");
            }
            if (linkType.isPluginModule()) {
                args.addElement("-shared");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-shared");
            }
        }
    }

    public void addIncremental(boolean incremental, Vector args) {
        if (incremental) {
            args.addElement("-i");
        }
    }

    protected int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
        }
        return offset + libnames.length;
    }

    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        Vector<String> libnames = new Vector<String>();
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        LibraryTypeEnum previousLibraryType = null;
        for (int i = 0; i < libsets.length; ++i) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                String relPath = libdir.getAbsolutePath();
                File currentDir = new File(".");
                if (currentDir != null && currentDir.getParentFile() != null) {
                    relPath = CUtil.getRelativePath(currentDir.getParentFile().getAbsolutePath(), libdir);
                }
                if (set.getType() != null && "framework".equals(set.getType().getValue()) && this.isDarwin()) {
                    endargs.addElement("-F" + relPath);
                } else {
                    endargs.addElement("-L" + relPath);
                }
            }
            if (set.getType() != previousLibraryType) {
                if (set.getType() != null && "static".equals(set.getType().getValue())) {
                    if (!this.isDarwin()) {
                        endargs.addElement(this.getStaticLibFlag());
                        previousLibraryType = set.getType();
                    }
                } else if (set.getType() == null || !"framework".equals(set.getType().getValue()) && !this.isDarwin()) {
                    endargs.addElement(this.getDynamicLibFlag());
                    previousLibraryType = set.getType();
                }
            }
            StringBuffer buf = new StringBuffer("-l");
            if (set.getType() != null && "framework".equals(set.getType().getValue()) && this.isDarwin()) {
                buf.setLength(0);
                endargs.addElement("-framework");
            }
            int initialLength = buf.length();
            for (int j = 0; j < libs.length; ++j) {
                buf.setLength(initialLength);
                buf.append(libs[j]);
                libnames.addElement(libs[j]);
                endargs.addElement(buf.toString());
            }
        }
        if (previousLibraryType != null && previousLibraryType.getValue().equals("static") && !this.isDarwin()) {
            endargs.addElement(this.getDynamicLibFlag());
        }
        String[] rc = new String[libnames.size()];
        for (int i = 0; i < libnames.size(); ++i) {
            rc[i] = (String)libnames.elementAt(i);
        }
        return rc;
    }

    public void addMap(boolean map, Vector args) {
        if (map) {
            args.addElement("-M");
        }
    }

    public void addStack(int stack, Vector args) {
        if (stack > 0) {
            args.addElement("--stack");
            args.addElement(Integer.toString(stack));
        }
    }

    protected void addEntry(String entry, Vector args) {
        if (entry != null) {
            args.addElement("-e");
            args.addElement(entry);
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        throw new IllegalStateException("ld does not support command files");
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("LIB", ":");
    }

    public String getLibraryKey(File libfile) {
        String libname = libfile.getName();
        int lastDot = libname.lastIndexOf(46);
        if (lastDot >= 0) {
            return libname.substring(0, lastDot);
        }
        return libname;
    }

    public File[] getLibraryPath() {
        return new File[0];
    }

    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        int patternCount = libnames.length;
        if (libType == null) {
            patternCount *= 2;
        }
        String[] patterns = new String[patternCount];
        int offset = 0;
        if (libType == null || "static".equals(libType.getValue())) {
            offset = this.addLibraryPatterns(libnames, buf, "lib", ".a", patterns, 0);
        }
        if (libType != null && "framework".equals(libType.getValue()) && this.isDarwin()) {
            for (int i = 0; i < libnames.length; ++i) {
                buf.setLength(0);
                buf.append(libnames[i]);
                buf.append(".framework/");
                buf.append(libnames[i]);
                patterns[offset++] = buf.toString();
            }
        } else if (libType == null || !"static".equals(libType.getValue())) {
            offset = this.isHPUX() ? this.addLibraryPatterns(libnames, buf, "lib", ".sl", patterns, offset) : this.addLibraryPatterns(libnames, buf, "lib", ".so", patterns, offset);
        }
        return patterns;
    }

    public int getMaximumCommandLength() {
        return this.isWindows() ? 20000 : Integer.MAX_VALUE;
    }

    public String[] getOutputFileNames(String baseName, VersionInfo versionInfo) {
        String[] baseNames = super.getOutputFileNames(baseName, versionInfo);
        if (this.outputPrefix.length() > 0) {
            for (int i = 0; i < baseNames.length; ++i) {
                baseNames[i] = this.outputPrefix + baseNames[i];
            }
        }
        return baseNames;
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return GccProcessor.getOutputFileSwitch("-o", outputFile);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected boolean isHPUX() {
        String osname = System.getProperty("os.name").toLowerCase();
        return osname.indexOf("hp") >= 0 && osname.indexOf("ux") >= 0;
    }

    public String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] libnames = config.getLibraryNames();
        if (libnames == null || libnames.length == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] localSources = (String[])sourceFiles.clone();
        int extra = 0;
        for (int i = 0; i < libnames.length; ++i) {
            String libname = libnames[i];
            for (int j = 0; j < localSources.length; ++j) {
                String extension;
                String filename;
                if (localSources[j] == null || localSources[j].indexOf(libname) <= 0 || localSources[j].indexOf("lib") <= 0 || !(filename = new File(localSources[j]).getName()).startsWith("lib") || !filename.substring(3).startsWith(libname) || !(extension = filename.substring(libname.length() + 3)).equals(".a") && !extension.equals(".so") && !extension.equals(".sl")) continue;
                localSources[j] = null;
                ++extra;
            }
        }
        if (extra == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] finalSources = new String[localSources.length - extra];
        int index = 0;
        for (int i = 0; i < localSources.length; ++i) {
            if (localSources[i] == null) continue;
            finalSources[index++] = localSources[i];
        }
        return super.prepareArguments(task, outputDir, outputFile, finalSources, config);
    }

    protected String getDynamicLibFlag() {
        return "-Bdynamic";
    }

    protected String getStaticLibFlag() {
        return "-Bstatic";
    }
}

