/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractDependencyMojo;
import com.github.maven_nar.Assembler;
import com.github.maven_nar.C;
import com.github.maven_nar.Cpp;
import com.github.maven_nar.Fortran;
import com.github.maven_nar.IDL;
import com.github.maven_nar.Java;
import com.github.maven_nar.Message;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarLogger;
import com.github.maven_nar.Resource;
import com.github.maven_nar.SysLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public abstract class AbstractCompileMojo
extends AbstractDependencyMojo {
    @Parameter
    private Cpp cpp;
    @Parameter
    private C c;
    @Parameter
    private Fortran fortran;
    @Parameter
    private Assembler assembler;
    @Parameter
    private Resource resource;
    @Parameter
    private IDL idl;
    @Parameter
    private Message message;
    @Parameter(defaultValue="false")
    protected boolean onlySpecifiedCompilers;
    @Parameter
    protected int commandLogLevel = 3;
    @Parameter
    private int maxCores = 0;
    @Parameter(defaultValue="true", required=true)
    private boolean failOnError;
    @Parameter(defaultValue="dynamic", required=true)
    private String runtime;
    @Parameter(defaultValue="false", required=true)
    private boolean libtool;
    @Parameter(defaultValue="false")
    protected boolean directDepsOnly;
    @Parameter(defaultValue="")
    protected String sharedObjectName;
    @Parameter
    private List tests;
    @Parameter
    private Java java;
    @Parameter(defaultValue="")
    private String fortifyID;
    @Parameter
    protected boolean decorateLinkerOptions;
    @Parameter(defaultValue="false", required=true)
    protected boolean syslibsFromDependencies;
    private List dependencyLibOrder;
    private Project antProject;
    protected final List<String[]> compileCommands = new ArrayList<String[]>();
    protected final List<String[]> linkCommands = new ArrayList<String[]>();
    protected final List<String[]> testCompileCommands = new ArrayList<String[]>();
    protected final List<String[]> testLinkCommands = new ArrayList<String[]>();

    protected final boolean failOnError(AOL aol) throws MojoExecutionException {
        return this.getNarInfo().getProperty(aol, "failOnError", this.failOnError);
    }

    protected final Project getAntProject() {
        if (this.antProject == null) {
            this.antProject = new Project();
            this.antProject.setName("NARProject");
            this.antProject.addBuildListener((BuildListener)new NarLogger(this.getLog()));
        }
        return this.antProject;
    }

    protected final C getC() {
        if (this.c == null && !this.onlySpecifiedCompilers) {
            this.setC(new C());
        }
        return this.c;
    }

    protected final Cpp getCpp() {
        if (this.cpp == null && !this.onlySpecifiedCompilers) {
            this.setCpp(new Cpp());
        }
        return this.cpp;
    }

    protected final List getDependencyLibOrder() {
        return this.dependencyLibOrder;
    }

    protected final Fortran getFortran() {
        if (this.fortran == null && !this.onlySpecifiedCompilers) {
            this.setFortran(new Fortran());
        }
        return this.fortran;
    }

    protected final Assembler getAssembler() {
        if (this.assembler == null) {
            this.assembler = new Assembler();
        }
        this.assembler.setAbstractCompileMojo(this);
        return this.assembler;
    }

    protected final IDL getIdl() {
        if (this.idl == null && !this.onlySpecifiedCompilers) {
            this.setIdl(new IDL());
        }
        return this.idl;
    }

    protected final Java getJava() {
        if (this.java == null) {
            this.java = new Java();
        }
        this.java.setAbstractCompileMojo(this);
        return this.java;
    }

    protected final int getMaxCores(AOL aol) throws MojoExecutionException {
        return this.getNarInfo().getProperty(aol, "maxCores", this.maxCores);
    }

    protected boolean getDirectDepsOnly() {
        return this.directDepsOnly;
    }

    protected final Message getMessage() {
        if (this.message == null && !this.onlySpecifiedCompilers) {
            this.setMessage(new Message());
        }
        return this.message;
    }

    protected final String getOutput(AOL aol, String type) throws MojoExecutionException {
        return this.getNarInfo().getOutput(aol, this.getOutput(!"executable".equals(type)));
    }

    protected final Resource getResource() {
        if (this.resource == null && !this.onlySpecifiedCompilers) {
            this.setResource(new Resource());
        }
        return this.resource;
    }

    protected final String getRuntime(AOL aol) throws MojoExecutionException {
        return this.getNarInfo().getProperty(aol, "runtime", this.runtime);
    }

    protected final List getTests() {
        if (this.tests == null) {
            this.tests = Collections.emptyList();
        }
        return this.tests;
    }

    public void setC(C c) {
        this.c = c;
        c.setAbstractCompileMojo(this);
    }

    public void setCpp(Cpp cpp) {
        this.cpp = cpp;
        cpp.setAbstractCompileMojo(this);
    }

    protected final String getfortifyID() {
        return this.fortifyID;
    }

    public final void setDependencyLibOrder(List order) {
        this.dependencyLibOrder = order;
    }

    public void setFortran(Fortran fortran) {
        this.fortran = fortran;
        fortran.setAbstractCompileMojo(this);
    }

    public void setIdl(IDL idl) {
        this.idl = idl;
        idl.setAbstractCompileMojo(this);
    }

    public void setMessage(Message message) {
        this.message = message;
        message.setAbstractCompileMojo(this);
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        resource.setAbstractCompileMojo(this);
    }

    protected final boolean useLibtool(AOL aol) throws MojoExecutionException {
        return this.getNarInfo().getProperty(aol, "libtool", this.libtool);
    }

    public List<SysLib> getDependecySysLib(NarArtifact dependency) throws MojoExecutionException, MojoFailureException {
        String sysLibs = dependency.getNarInfo().getSysLibs(this.getAOL());
        ArrayList<SysLib> l = new ArrayList<SysLib>();
        if (sysLibs != null && !sysLibs.equals("")) {
            String[] split;
            this.getLog().debug((CharSequence)("Using SYSLIBS = " + sysLibs));
            for (String s : split = sysLibs.split(",")) {
                String[] typeAndValue = s.split(":", 2);
                if (typeAndValue.length != 2) {
                    throw new MojoExecutionException("Malformed syslib from dependency: " + s);
                }
                SysLib sysLib = new SysLib();
                sysLib.setName(typeAndValue[0]);
                sysLib.setType(typeAndValue[1]);
                l.add(sysLib);
            }
        }
        return l;
    }
}

