/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.NarConstants;
import com.github.maven_nar.NarLayout;
import com.github.maven_nar.NarLayout21;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public abstract class AbstractNarLayout
implements NarLayout,
NarConstants {
    private final Log log;

    public static NarLayout getLayout(String layoutName, Log log) throws MojoExecutionException {
        String className = layoutName.indexOf(46) < 0 ? NarLayout21.class.getPackage().getName() + "." + layoutName : layoutName;
        log.debug((CharSequence)("Using " + className));
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> ctor = cls.getConstructor(Log.class);
            return (NarLayout)ctor.newInstance(log);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Cannot find class for layout " + className, (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Cannot instantiate class for layout " + className, (Exception)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            throw new MojoExecutionException("Cannot access class for layout " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Cannot find ctor(Log) for layout " + className, (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Wrong arguments ctor(Log) for layout " + className, (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Cannot invokector(Log) for layout " + className, (Exception)e);
        }
    }

    protected AbstractNarLayout(Log log) {
        this.log = log;
    }

    protected final void attachNar(ArchiverManager archiverManager, MavenProjectHelper projectHelper, MavenProject project, String classifier, File dir, String include) throws MojoExecutionException {
        File narFile = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + "-" + classifier + "." + "nar");
        if (narFile.exists()) {
            narFile.delete();
        }
        try {
            Archiver archiver = archiverManager.getArchiver("nar");
            archiver.addDirectory(dir, new String[]{include}, null);
            archiver.setDestFile(narFile);
            archiver.createArchive();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("NAR: cannot find archiver", (Exception)((Object)e));
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("NAR: cannot create NAR archive '" + narFile + "'", (Exception)e);
        }
        projectHelper.attachArtifact(project, "nar", classifier, narFile);
    }

    protected Log getLog() {
        return this.log;
    }

    protected void unpackNarAndProcess(ArchiverManager archiverManager, File file, File narLocation, String os, String linkerName, AOL defaultAOL, boolean skipRanlib) throws MojoExecutionException, MojoFailureException {
        String gpp = "g++";
        String gcc = "gcc";
        narLocation.mkdirs();
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver("nar");
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(narLocation);
            unArchiver.extract();
        }
        catch (ArchiverException | NoSuchArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + narLocation, (Exception)e);
        }
        if (!NarUtil.getOS(os).equals("Windows")) {
            NarUtil.makeExecutable(new File(narLocation, "bin/" + defaultAOL), this.log);
            if (defaultAOL.hasLinker("g++")) {
                NarUtil.makeExecutable(new File(narLocation, "bin/" + NarUtil.replace("g++", "gcc", defaultAOL.toString())), this.log);
            }
            NarUtil.makeLink(new File(narLocation, "lib/" + defaultAOL), this.log);
        }
        if (linkerName.equals("gcc") || linkerName.equals("g++")) {
            if (!skipRanlib) {
                NarUtil.runRanlib(new File(narLocation, "lib/" + defaultAOL), this.log);
            }
            if (defaultAOL.hasLinker("g++") && !skipRanlib) {
                NarUtil.runRanlib(new File(narLocation, "lib/" + NarUtil.replace("g++", "gcc", defaultAOL.toString())), this.log);
            }
        }
    }
}

