/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.Executable;
import com.github.maven_nar.NarArtifact;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class Library
implements Executable {
    public static final String STATIC = "static";
    public static final String SHARED = "shared";
    public static final String EXECUTABLE = "executable";
    public static final String JNI = "jni";
    public static final String PLUGIN = "plugin";
    public static final String NONE = "none";
    @Parameter
    private String type = "shared";
    @Parameter
    private String subSystem = "console";
    @Parameter(defaultValue="true")
    private boolean linkCPP = true;
    @Parameter
    private boolean linkFortran = false;
    @Parameter
    private boolean linkFortranMain = false;
    @Parameter
    private String narSystemPackage = null;
    @Parameter(defaultValue="NarSystem", required=true)
    private String narSystemName = "NarSystem";
    @Parameter(defaultValue="${project.build.dir}/nar/nar-generated", required=true)
    private String narSystemDirectory = "nar-generated";
    @Parameter
    private boolean run = false;
    @Parameter
    private List args = new ArrayList();
    @Parameter
    private List<String> dependencyBindings = new ArrayList<String>();

    @Override
    public final List getArgs() {
        return this.args;
    }

    @Override
    public String getBinding(NarArtifact dependency) {
        for (String dependBind : this.dependencyBindings) {
            String result;
            String[] pair = dependBind.trim().split(":", 2);
            if (!dependency.getArtifactId().equals(pair[0].trim()) || (result = pair[1].trim()).isEmpty()) continue;
            return result;
        }
        return null;
    }

    public final String getNarSystemDirectory() {
        return this.narSystemDirectory;
    }

    public final String getNarSystemName() {
        return this.narSystemName;
    }

    public final String getNarSystemPackage() {
        return this.narSystemPackage;
    }

    public String getSubSystem() {
        return this.subSystem;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean linkCPP() {
        return this.linkCPP;
    }

    public final boolean linkFortran() {
        return this.linkFortran;
    }

    public final boolean linkFortranMain() {
        return this.linkFortranMain;
    }

    @Override
    public final boolean shouldRun() {
        return this.run;
    }

    public final String toString() {
        String sb = "Library: type: " + this.getType();
        return sb;
    }
}

