/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.Lib;
import com.github.maven_nar.Msvc;
import com.github.maven_nar.NarCompileMojo;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.StringTextStream;
import com.github.maven_nar.SysLib;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.LinkerEnum;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.util.FileUtils;

public class Linker {
    @Parameter
    private String name;
    @Parameter
    private String prefix;
    @Parameter
    private String toolPath;
    @Parameter(required=true)
    private boolean incremental = false;
    @Parameter(required=true)
    private boolean map = false;
    @Parameter(required=true)
    private boolean skipDepLink = false;
    @Parameter
    private List options;
    @Parameter
    private List testOptions;
    @Parameter
    private String optionSet;
    @Parameter(required=true)
    private boolean clearDefaultOptions;
    @Parameter
    private List libs;
    @Parameter
    private String libSet;
    @Parameter
    private List sysLibs;
    @Parameter
    private String sysLibSet;
    @Parameter
    private String narDependencyLibOrder;
    @Parameter(defaultValue="false")
    private boolean narDefaultDependencyLibOrder = false;
    @Parameter(defaultValue="false")
    protected boolean pushDepsToLowestOrder = false;
    @Parameter(property="nar.generateManifest", defaultValue="true")
    private boolean generateManifest = true;
    private final Log log;

    public Linker() {
        this(null);
    }

    public Linker(Log log) {
        this.log = log;
    }

    public Linker(String name, Log log) {
        this.name = name;
        this.log = log;
    }

    private void addLibraries(String libraryList, LinkerDef linker, Project antProject, boolean isSystem) {
        String[] lib;
        if (libraryList == null) {
            return;
        }
        for (String element : lib = libraryList.split(",")) {
            String[] libInfo = element.trim().split(":", 3);
            LibrarySet librarySet = new LibrarySet();
            if (isSystem) {
                librarySet = new SystemLibrarySet();
            }
            librarySet.setProject(antProject);
            librarySet.setLibs(new CUtil.StringArrayBuilder(libInfo[0]));
            if (libInfo.length > 1) {
                LibraryTypeEnum libType = new LibraryTypeEnum();
                libType.setValue(libInfo[1]);
                librarySet.setType(libType);
                if (!isSystem && libInfo.length > 2) {
                    librarySet.setDir(new File(libInfo[2]));
                }
            }
            if (!isSystem) {
                linker.addLibset(librarySet);
                continue;
            }
            linker.addSyslibset((SystemLibrarySet)librarySet);
        }
    }

    public boolean isGenerateManifest() {
        return this.generateManifest;
    }

    /*
     * WARNING - void declaration
     */
    public final LinkerDef getLinker(AbstractCompileMojo mojo, CCTask task, String os, String prefix, String type, List<String> linkPaths) throws MojoFailureException, MojoExecutionException {
        String element;
        String option;
        Project antProject = task.getProject();
        if (this.name == null) {
            throw new MojoFailureException("NAR: Please specify a <Name> as part of <Linker>");
        }
        LinkerDef linker = new LinkerDef();
        linker.setProject(antProject);
        LinkerEnum linkerEnum = new LinkerEnum();
        linkerEnum.setValue(this.name);
        linker.setName(linkerEnum);
        if (this.toolPath != null) {
            linker.setToolPath(this.toolPath);
        } else if (Msvc.isMSVC(this.name)) {
            linker.setToolPath(mojo.getMsvc().getToolPath());
        }
        linker.setSkipDepLink(this.skipDepLink);
        linker.setLinkerPrefix(this.prefix);
        linker.setIncremental(this.incremental);
        linker.setMap(this.map);
        if (os.equals("Windows") && this.getName(null, null).equals("msvc") && (type.equals("shared") || type.equals("jni"))) {
            HashSet defs = new HashSet();
            try {
                if (mojo.getC() != null) {
                    List<File> list = mojo.getC().getSourceDirectories();
                    for (File cSrcDir : list) {
                        File file = cSrcDir;
                        if (!file.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)file, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (mojo.getCpp() != null) {
                    List<File> list = mojo.getCpp().getSourceDirectories();
                    for (File cppSrcDir : list) {
                        File file = cppSrcDir;
                        if (!file.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)file, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (mojo.getFortran() != null) {
                    List<File> list = mojo.getFortran().getSourceDirectories();
                    for (File fortranSrcDir : list) {
                        File file = fortranSrcDir;
                        if (!file.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)file, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (Object def : defs) {
                LinkerArgument arg2 = new LinkerArgument();
                arg2.setValue("/def:" + def);
                linker.addConfiguredLinkerArg(arg2);
            }
        }
        if (os.equals("Windows") && this.getName(null, null).equals("msvc") && !this.getVersion(mojo).startsWith("6.") && (type.equals("shared") || type.equals("jni") || type.equals("executable"))) {
            LinkerArgument arg = new LinkerArgument();
            if (this.isGenerateManifest()) {
                arg.setValue("/MANIFEST");
            } else {
                arg.setValue("/MANIFEST:NO");
            }
            linker.addConfiguredLinkerArg(arg);
            if (this.isGenerateManifest()) {
                LinkerArgument linkerArgument = new LinkerArgument();
                linkerArgument.setValue("/MANIFESTFILE:" + task.getOutfile() + ".manifest");
                linker.addConfiguredLinkerArg(linkerArgument);
            }
        }
        if (this.options != null) {
            for (Object e : this.options) {
                LinkerArgument arg = new LinkerArgument();
                arg.setValue((String)e);
                linker.addConfiguredLinkerArg(arg);
            }
        }
        if (this.optionSet != null) {
            String[] opts;
            for (String string : opts = this.optionSet.split("\\s")) {
                LinkerArgument arg = new LinkerArgument();
                arg.setValue(string);
                linker.addConfiguredLinkerArg(arg);
            }
        }
        if (!this.clearDefaultOptions && (option = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "options")) != null) {
            void var14_64;
            String[] stringArray;
            String[] arg = stringArray = option.split(" ");
            int arg2 = arg.length;
            boolean bl = false;
            while (var14_64 < arg2) {
                element = arg[var14_64];
                LinkerArgument arg3 = new LinkerArgument();
                arg3.setValue(element);
                linker.addConfiguredLinkerArg(arg3);
                ++var14_64;
            }
        }
        if (this.narDependencyLibOrder == null && this.narDefaultDependencyLibOrder) {
            if (os.equals("AIX") && (this.getName(null, null).equals("xlC_r") || this.getName(null, null).equals("xlC") || this.getName(null, null).equals("xlc"))) {
                String dependencies = mojo.dependencyTreeOrderStr(this.pushDepsToLowestOrder, mojo.getDirectDepsOnly());
                List<String> list = Arrays.asList(dependencies.split("\\s*,\\s*"));
                Collections.reverse(list);
                StringBuilder libOrder = new StringBuilder();
                boolean first = true;
                for (String dependency : list) {
                    if (first) {
                        first = false;
                    } else {
                        libOrder.append(",");
                    }
                    libOrder.append(dependency);
                }
                this.narDependencyLibOrder = libOrder.toString();
            } else {
                this.narDependencyLibOrder = mojo.dependencyTreeOrderStr(this.pushDepsToLowestOrder, mojo.getDirectDepsOnly());
            }
        } else if (this.pushDepsToLowestOrder && !this.narDefaultDependencyLibOrder) {
            mojo.getLog().warn((CharSequence)"pushDepsToLowestOrder will have no effect since narDefaultDependencyLibOrder is disabled");
        } else if (mojo.getDirectDepsOnly() && !this.narDefaultDependencyLibOrder) {
            mojo.getLog().warn((CharSequence)"directDepsOnly will have no effect since narDefaultDependencyLibOrder is disabled");
        }
        if (linkPaths != null && linkPaths.size() > 0 && mojo.getDirectDepsOnly() && !type.equals("static") && (os.equals("Linux") || os.equals("AIX"))) {
            StringBuilder argStrBuilder = new StringBuilder();
            if (os.equals("Linux")) {
                argStrBuilder.append("-Wl,-rpath-link,");
            } else if (os.equals("AIX")) {
                argStrBuilder.append("-L");
            }
            for (String path : linkPaths) {
                argStrBuilder.append(path).append(':');
            }
            String string = argStrBuilder.toString();
            LinkerArgument linkPathArg = new LinkerArgument();
            linkPathArg.setValue(string.substring(0, string.length() - 1));
            linker.addConfiguredLinkerArg(linkPathArg);
        }
        if (this.narDependencyLibOrder != null) {
            void var14_67;
            String[] stringArray;
            LinkedList libOrder = new LinkedList();
            String[] linkPathArg = stringArray = this.narDependencyLibOrder.split(",");
            int n = linkPathArg.length;
            boolean bl = false;
            while (var14_67 < n) {
                element = linkPathArg[var14_67];
                libOrder.add(element.trim());
                ++var14_67;
            }
            mojo.setDependencyLibOrder(libOrder);
        }
        if (this.libs != null || this.libSet != null) {
            if (this.libs != null) {
                for (Object e : this.libs) {
                    Lib lib = (Lib)e;
                    lib.addLibSet(mojo, linker, antProject);
                }
            }
            if (this.libSet != null) {
                this.addLibraries(this.libSet, linker, antProject, false);
            }
        } else {
            String libsList = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "libs");
            this.addLibraries(libsList, linker, antProject, false);
        }
        if (this.sysLibs != null || this.sysLibSet != null) {
            if (this.sysLibs != null) {
                for (Object e : this.sysLibs) {
                    SysLib sysLib = (SysLib)e;
                    linker.addSyslibset(sysLib.getSysLibSet(antProject));
                }
            }
            if (this.sysLibSet != null) {
                this.addLibraries(this.sysLibSet, linker, antProject, true);
            }
        } else {
            String sysLibsList = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "sysLibs");
            this.addLibraries(sysLibsList, linker, antProject, true);
        }
        mojo.getMsvc().configureLinker(linker);
        return linker;
    }

    public final String getName() {
        return this.name;
    }

    public final String getName(NarProperties properties, String prefix) throws MojoFailureException, MojoExecutionException {
        if (this.name == null && properties != null && prefix != null) {
            this.name = properties.getProperty(prefix + "linker");
        }
        if (this.name == null) {
            throw new MojoExecutionException("NAR: One of two things may be wrong here:\n\n1. <Name> tag is missing inside the <Linker> tag of your NAR configuration\n\n2. no linker is defined in the aol.properties file for '" + prefix + "linker'\n");
        }
        return this.name;
    }

    public final LinkerDef getTestLinker(AbstractCompileMojo mojo, CCTask task, String os, String prefix, String type, List<String> linkPaths) throws MojoFailureException, MojoExecutionException {
        LinkerDef linker = this.getLinker(mojo, task, os, prefix, type, linkPaths);
        if (this.testOptions != null) {
            for (Object testOption : this.testOptions) {
                LinkerArgument arg = new LinkerArgument();
                arg.setValue((String)testOption);
                linker.addConfiguredLinkerArg(arg);
            }
        }
        return linker;
    }

    public final String getVersion() throws MojoFailureException, MojoExecutionException {
        return this.getVersion(new NarCompileMojo());
    }

    public final String getVersion(AbstractNarMojo mojo) throws MojoFailureException, MojoExecutionException {
        if (this.name == null) {
            throw new MojoFailureException("Cannot deduce linker version if name is null");
        }
        String version = null;
        String linkerPrefix = "";
        if (this.prefix != null && !this.prefix.isEmpty()) {
            linkerPrefix = this.prefix;
        }
        StringTextStream out = new StringTextStream();
        StringTextStream err = new StringTextStream();
        StringTextStream dbg = new StringTextStream();
        if (this.name.equals("g++") || this.name.equals("gcc")) {
            NarUtil.runCommand(linkerPrefix + "gcc", new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("msvc")) {
            version = mojo.getMsvc().getVersion();
        } else if (this.name.equals("icc") || this.name.equals("icpc")) {
            NarUtil.runCommand("icc", new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("icl")) {
            NarUtil.runCommand("icl", new String[]{"/QV"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)err).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("CC")) {
            NarUtil.runCommand("CC", new String[]{"-V"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)err).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("xlC")) {
            NarUtil.runCommand("/usr/vacpp/bin/xlC", new String[]{"-qversion"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("xlC_r")) {
            NarUtil.runCommand("xlC_r", new String[]{"-qversion"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("clang") || this.name.equals("clang++")) {
            NarUtil.runCommand("clang", new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (!this.prefix.isEmpty()) {
            NarUtil.runCommand(linkerPrefix + this.name, new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else {
            throw new MojoFailureException("Cannot find version number for linker '" + this.name + "'");
        }
        if (version == null) {
            if (!((Object)err).toString().isEmpty()) {
                mojo.getLog().debug((CharSequence)("linker returned error stream: " + ((Object)err).toString()));
            }
            throw new MojoFailureException("Cannot deduce version number from: " + ((Object)out).toString());
        }
        return version;
    }

    public List getSysLibs() {
        return this.sysLibs;
    }

    public String getSysLibSet() {
        return this.sysLibSet;
    }
}

