/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.StringTextStream;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.types.SystemIncludePath;
import com.google.common.collect.Sets;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.types.Environment;
import org.codehaus.plexus.util.StringUtils;

public class Msvc {
    private File home;
    private AbstractNarMojo mojo = null;
    private final Set<String> paths = new LinkedHashSet<String>();
    private String version = "";
    private File windowsSdkHome;
    private String windowsSdkVersion;
    private String tempPath;
    private boolean force_requested_arch = false;
    private File windowsHome;
    private File msvctoolhome;
    private String toolPathWindowsSDK;
    private String toolPathLinker;
    private List<File> sdkIncludes = new ArrayList<File>();
    private List<File> sdkLibs = new ArrayList<File>();
    private Set<String> libsRequired = Sets.newHashSet((Object[])new String[]{"ucrt", "um", "shared", "winrt"});
    private final Comparator<String> versionStringComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            DefaultArtifactVersion version1 = new DefaultArtifactVersion(o1);
            DefaultArtifactVersion version2 = new DefaultArtifactVersion(o2);
            return version1.compareTo((ArtifactVersion)version2);
        }
    };
    private final Comparator<File> versionComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            String firstDir = o2.getName();
            String secondDir = o1.getName();
            if (firstDir.charAt(0) == 'v') {
                firstDir = firstDir.substring(1, firstDir.length() - 1);
                secondDir = secondDir.substring(1, secondDir.length() - 1);
            }
            String[] firstVersionString = firstDir.split("\\.");
            String[] secondVersionString = secondDir.split("\\.");
            int maxIdx = Math.min(firstVersionString.length, secondVersionString.length);
            try {
                for (int i = 0; i < maxIdx; ++i) {
                    int deltaVer = Integer.parseInt(firstVersionString[i]) - Integer.parseInt(secondVersionString[i]);
                    if (deltaVer == 0) continue;
                    return deltaVer;
                }
            }
            catch (NumberFormatException e) {
                return firstDir.compareTo(secondDir);
            }
            if (firstVersionString.length > maxIdx) {
                return 1;
            }
            if (secondVersionString.length > maxIdx) {
                return -1;
            }
            return 0;
        }
    };
    private boolean foundSDK = false;

    static boolean isMSVC(AbstractNarMojo mojo) {
        return Msvc.isMSVC(mojo.getLinker().getName());
    }

    static boolean isMSVC(String name) {
        return "msvc".equalsIgnoreCase(name);
    }

    public String getVersion() {
        return this.version;
    }

    public String getWindowsSdkVersion() {
        return this.windowsSdkVersion;
    }

    public Environment.Variable getPathVariable() {
        if (this.paths.isEmpty()) {
            return null;
        }
        Environment.Variable pathVariable = new Environment.Variable();
        pathVariable.setKey("PATH");
        pathVariable.setValue(StringUtils.join(this.paths.iterator(), (String)File.pathSeparator));
        return pathVariable;
    }

    public String toString() {
        return "VS Home-" + this.home + "\nSDKHome-" + this.windowsSdkHome;
    }

    public String getToolPath() {
        return this.toolPathLinker;
    }

    public String getSDKToolPath() {
        return this.toolPathWindowsSDK;
    }

    public void setToolPath(CompilerDef compilerDef, String name) {
        if ("res".equals(name) || "mc".equals(name) || "idl".equals(name)) {
            compilerDef.setToolPath(this.toolPathWindowsSDK);
        } else {
            compilerDef.setToolPath(this.toolPathLinker);
        }
    }

    public void init(AbstractNarMojo mojo) throws MojoFailureException, MojoExecutionException {
        if (this.mojo != mojo && Msvc.isMSVC(mojo)) {
            this.mojo = mojo;
            String mojoOs = mojo.getOS();
            if (NarUtil.isWindows() && "Windows".equals(mojoOs) && Msvc.isMSVC(mojo)) {
                String sdkDir;
                String msvcDir;
                this.windowsHome = new File(System.getenv("SystemRoot"));
                String versionProperty = mojo.getWindowsMsvcVersion();
                if (versionProperty != null) {
                    this.version = versionProperty;
                }
                if ((msvcDir = mojo.getWindowsMsvcDir()) != null) {
                    this.home = new File(msvcDir);
                } else {
                    this.initVisualStudio();
                    if (!this.version.isEmpty()) {
                        mojo.getLog().debug((CharSequence)String.format(" Using VisualStudio %1s home %2s ", this.version, this.home));
                    } else {
                        StringTextStream out = new StringTextStream();
                        StringTextStream err = new StringTextStream();
                        StringTextStream dbg = new StringTextStream();
                        NarUtil.runCommand("link", new String[]{"/?"}, null, null, out, err, dbg, null, true);
                        Pattern p = Pattern.compile("(\\d+\\.\\d+)\\.\\d+(\\.\\d+)?");
                        Matcher m = p.matcher(((Object)out).toString());
                        if (m.find()) {
                            this.version = m.group(1);
                            mojo.getLog().debug((CharSequence)String.format(" VisualStudio Not found but link runs and reports version %1s (%2s)", this.version, m.group(0)));
                            return;
                        }
                        throw new MojoExecutionException("msvc.version not specified and no VS7 SxS or VS<Version>COMNTOOLS environment variable can be found");
                    }
                }
                this.msvctoolhome = this.VCToolHome();
                String windowsSdkVersionProperty = mojo.getWindowsSdkVersion();
                if (windowsSdkVersionProperty != null) {
                    this.windowsSdkVersion = windowsSdkVersionProperty;
                }
                if ((sdkDir = mojo.getWindowsSdkDir()) != null) {
                    this.windowsSdkHome = new File(sdkDir);
                } else {
                    this.initWindowsSdk();
                }
                String mojoArchitecture = mojo.getArchitecture();
                String osArchitecture = NarUtil.getArchitecture(null);
                CrossCompilers compiler = this.force_requested_arch ? ("amd64".equals(mojoArchitecture) ? ("amd64".equals(osArchitecture) ? CrossCompilers.x64 : CrossCompilers.x86_x64) : CrossCompilers.x86) : ("amd64".equals(osArchitecture) ? ("amd64".equals(mojoArchitecture) ? CrossCompilers.x64 : ("arm".equals(mojoArchitecture) ? CrossCompilers.x64_arm : CrossCompilers.x64_x86)) : ("amd64".equals(mojoArchitecture) ? CrossCompilers.x86_x64 : ("arm".equals(mojoArchitecture) ? CrossCompilers.x86_arm : CrossCompilers.x86)));
                this.initPath(compiler);
                this.addWindowsSDKPaths();
                this.addWindowsPaths();
            } else {
                this.version = "";
                this.windowsSdkVersion = "";
                this.windowsHome = null;
            }
        }
    }

    public void configureCCTask(CCTask task) throws MojoExecutionException {
        if (this.mojo != null && "Windows".equals(this.mojo.getOS()) && Msvc.isMSVC(this.mojo)) {
            this.addIncludePath(task, this.msvctoolhome, "include");
            this.addIncludePath(task, this.msvctoolhome, "atlmfc/include");
            if (this.compareVersion(this.windowsSdkVersion, "7.1A") <= 0) {
                if (this.version.equals("8.0")) {
                    for (File sdkInclude : this.sdkIncludes) {
                        this.addIncludePathToTask(task, sdkInclude);
                        this.mojo.getLog().debug((CharSequence)(" configureCCTask add to Path-- " + sdkInclude.getAbsolutePath()));
                    }
                } else {
                    this.addIncludePath(task, this.windowsSdkHome, "include");
                }
            } else {
                for (File sdkInclude : this.sdkIncludes) {
                    this.addIncludePathToTask(task, sdkInclude);
                }
            }
            task.addEnv(this.getPathVariable());
            Environment.Variable envVariable = new Environment.Variable();
            envVariable.setKey("SystemRoot");
            envVariable.setValue(this.windowsHome.getAbsolutePath());
            task.addEnv(envVariable);
            envVariable = new Environment.Variable();
            envVariable.setKey("TMP");
            envVariable.setValue(this.getTempPath());
            task.addEnv(envVariable);
        }
    }

    public void configureLinker(LinkerDef linker) throws MojoExecutionException {
        if (this.mojo != null && "Windows".equals(this.mojo.getOS()) && Msvc.isMSVC(this.mojo)) {
            String arch;
            String sdkArch = arch = this.mojo.getArchitecture();
            if ("amd64".equals(arch)) {
                sdkArch = "x64";
            }
            if (this.compareVersion(this.version, "15.0") < 0) {
                if ("x86".equals(arch)) {
                    linker.addLibraryDirectory(this.msvctoolhome, "lib");
                    linker.addLibraryDirectory(this.msvctoolhome, "atlmfc/lib");
                } else {
                    linker.addLibraryDirectory(this.msvctoolhome, "lib/" + arch);
                    linker.addLibraryDirectory(this.msvctoolhome, "atlmfc/lib/" + arch);
                }
            } else {
                linker.addLibraryDirectory(this.msvctoolhome, "lib/" + sdkArch);
                linker.addLibraryDirectory(this.msvctoolhome, "atlmfc/lib/" + sdkArch);
            }
            if (this.compareVersion(this.windowsSdkVersion, "8.0") < 0) {
                if ("x86".equals(arch)) {
                    linker.addLibraryDirectory(this.windowsSdkHome, "lib");
                } else {
                    linker.addLibraryDirectory(this.windowsSdkHome, "lib/" + sdkArch);
                }
            } else {
                for (File sdkLib : this.sdkLibs) {
                    linker.addLibraryDirectory(sdkLib, sdkArch);
                }
            }
        }
    }

    private boolean addIncludePath(CCTask task, File base, String subDirectory) throws MojoExecutionException {
        if (base == null) {
            return false;
        }
        File file = new File(base, subDirectory);
        if (file.exists()) {
            return this.addIncludePathToTask(task, file);
        }
        return false;
    }

    private boolean addIncludePathToTask(CCTask task, File file) throws MojoExecutionException {
        try {
            SystemIncludePath includePath = task.createSysIncludePath();
            String fullPath = file.getCanonicalPath();
            includePath.setPath(fullPath);
            return true;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to add system include: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private boolean addPath(File base, String path) {
        File directory;
        if (base != null && (directory = new File(base, path)).exists()) {
            try {
                String fullPath = directory.getCanonicalPath();
                this.paths.add(fullPath);
                return true;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to get path: " + directory, e);
            }
        }
        return false;
    }

    private String getTempPath() {
        if (null == this.tempPath) {
            this.tempPath = System.getenv("TMP");
            if (this.tempPath == null) {
                this.tempPath = System.getenv("TEMP");
            }
            if (this.tempPath == null) {
                this.tempPath = "C:\\Temp";
            }
        }
        return this.tempPath;
    }

    private void initPath(CrossCompilers compiler) throws MojoExecutionException {
        Boolean found = true;
        if (this.compareVersion(this.version, "15.0") < 0) {
            switch (compiler) {
                case x86: {
                    found = this.addPath(this.msvctoolhome, "bin");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin").getAbsolutePath();
                    break;
                }
                case x86_x64: {
                    found = this.addPath(this.msvctoolhome, "bin/x86_amd64");
                    this.addPath(this.msvctoolhome, "bin");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/x86_amd64").getAbsolutePath();
                    break;
                }
                case x86_arm: {
                    found = this.addPath(this.msvctoolhome, "bin/x86_arm");
                    this.addPath(this.msvctoolhome, "bin");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/x86_arm").getAbsolutePath();
                    break;
                }
                case x64: {
                    found = this.addPath(this.msvctoolhome, "bin/amd64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/amd64").getAbsolutePath();
                    break;
                }
                case x64_x86: {
                    found = this.addPath(this.msvctoolhome, "bin/amd64_x86");
                    this.addPath(this.msvctoolhome, "bin/amd64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/amd64_x86").getAbsolutePath();
                    break;
                }
                case x64_arm: {
                    found = this.addPath(this.msvctoolhome, "bin/amd64_arm");
                    this.addPath(this.msvctoolhome, "bin/amd64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/amd64_arm").getAbsolutePath();
                }
            }
        } else {
            switch (compiler) {
                case x86: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX86/x86");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX86/x86").getAbsolutePath();
                    break;
                }
                case x86_x64: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX86/x64");
                    this.addPath(this.msvctoolhome, "bin/HostX86/x86");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX86/x64").getAbsolutePath();
                    break;
                }
                case x86_arm: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX86/arm");
                    this.addPath(this.msvctoolhome, "bin/HostX86/x86");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX86/arm").getAbsolutePath();
                    break;
                }
                case x64: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX64/x64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX64/x64").getAbsolutePath();
                    break;
                }
                case x64_x86: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX64/x86");
                    this.addPath(this.msvctoolhome, "bin/HostX64/x64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX64/x86").getAbsolutePath();
                    break;
                }
                case x64_arm: {
                    found = this.addPath(this.msvctoolhome, "bin/HostX64/arm");
                    this.addPath(this.msvctoolhome, "bin/HostX64/x64");
                    this.toolPathLinker = new File(this.msvctoolhome, "bin/HostX64/arm").getAbsolutePath();
                }
            }
        }
        if (!found.booleanValue()) {
            throw new MojoExecutionException("Unable to find bin folder for architecture " + compiler.name() + ".\n");
        }
        if (this.compareVersion(this.version, "15.0") < 0) {
            this.addPath(this.msvctoolhome, "VCPackages");
            this.addPath(this.home, "Common7/Tools");
            this.addPath(this.home, "Common7/IDE");
        } else {
            this.addPath(this.home, "Common7/IDE/VC/VCPackages");
            this.addPath(this.home, "Common7/IDE/");
            this.addPath(this.home, "Common7/Tools");
        }
    }

    private void addWindowsSDKPaths() throws MojoExecutionException {
        String versionPart;
        String mojoArchitecture = this.mojo.getArchitecture();
        String osArchitecture = NarUtil.getArchitecture(null);
        String string = versionPart = this.compareVersion(this.windowsSdkVersion, "10") < 0 ? "" : this.windowsSdkVersion + "/";
        if (this.compareVersion(this.windowsSdkVersion, "7.1A") <= 0) {
            if ("amd64".equals(osArchitecture)) {
                this.addPath(this.windowsSdkHome, "bin/x64");
            }
            this.addPath(this.windowsSdkHome, "bin");
        } else {
            if ("amd64".equals(osArchitecture)) {
                this.addPath(this.windowsSdkHome, "bin/" + versionPart + "x64");
            }
            this.addPath(this.windowsSdkHome, "bin/" + versionPart + "x86");
        }
        this.toolPathWindowsSDK = "amd64".equals(mojoArchitecture) ? new File(this.windowsSdkHome, "bin/" + versionPart + "x64").getAbsolutePath() : (this.compareVersion(this.windowsSdkVersion, "7.1A") <= 0 ? new File(this.windowsSdkHome, "bin").getAbsolutePath() : new File(this.windowsSdkHome, "bin/" + versionPart + "x86").getAbsolutePath());
        this.mojo.getLog().debug((CharSequence)String.format(" Using WindowSDK bin %1s", this.toolPathWindowsSDK));
    }

    private void addWindowsPaths() throws MojoExecutionException {
        this.addPath(this.windowsHome, "System32");
        this.addPath(this.windowsHome, "");
        this.addPath(this.windowsHome, "System32/wbem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String registryGet32StringValue(WinReg.HKEY root, String key, String value) throws Win32Exception {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 131609, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            String string = Advapi32Util.registryGetStringValue((WinReg.HKEY)phkKey.getValue(), (String)value);
            return string;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeMap<String, Object> visualStudioVS7SxS(WinReg.HKEY root, String key) {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 131609, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            TreeMap treeMap = Advapi32Util.registryGetValues((WinReg.HKEY)phkKey.getValue());
            return treeMap;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    private void initVisualStudio() throws MojoFailureException, MojoExecutionException {
        this.mojo.getLog().debug((CharSequence)" -- Searching for usable VisualStudio ");
        this.mojo.getLog().debug((CharSequence)("Requested Linker version is  \"" + this.version + "\""));
        if (this.version != null && this.version.trim().length() > 1) {
            File commonToolsDirectory;
            String commontToolsVar;
            Pattern r = Pattern.compile("(\\d+)\\.*(\\d)");
            Matcher matcher = r.matcher(this.version);
            if (!matcher.find()) {
                throw new MojoExecutionException("msvc.version must be the internal version in the form 10.0 or 120");
            }
            String internalVersion = matcher.group(1) + matcher.group(2);
            this.version = matcher.group(1) + "." + matcher.group(2);
            if (this.home == null) {
                this.home = new File(Msvc.registryGet32StringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\VisualStudio\\SxS\\VS7", this.version));
            }
            if ((this.home == null || !this.home.exists()) && (commontToolsVar = System.getenv("VS" + internalVersion + "COMNTOOLS")) != null && commontToolsVar.trim().length() > 0 && (commonToolsDirectory = new File(commontToolsVar)).exists()) {
                this.home = commonToolsDirectory.getParentFile().getParentFile();
            }
            this.mojo.getLog().debug((CharSequence)String.format(" VisualStudio %1s (%2s) found %3s ", this.version, internalVersion, this.home));
        } else {
            this.version = "";
            for (Map.Entry<String, Object> entry : Msvc.visualStudioVS7SxS(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\VisualStudio\\SxS\\VS7").entrySet()) {
                File vsDirectory;
                String newestVersion = entry.getKey();
                String value = entry.getValue().toString();
                this.mojo.getLog().debug((CharSequence)String.format(" VisualStudio %1s found SxS %3s ", newestVersion, value));
                if (this.versionStringComparator.compare(newestVersion, this.version) <= 0 || !(vsDirectory = new File(value)).exists()) continue;
                this.version = newestVersion;
                this.home = vsDirectory;
            }
            Pattern versionPattern = Pattern.compile("VS(\\d+)(\\d)COMNTOOLS");
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                File commonToolsDirectory;
                String key = entry.getKey();
                String value = entry.getValue();
                Matcher matcher = versionPattern.matcher(key);
                if (!matcher.matches()) continue;
                String newestVersion = matcher.group(1) + "." + matcher.group(2);
                this.mojo.getLog().debug((CharSequence)String.format(" VisualStudio %1s (%2s) common tools found %3s ", newestVersion, matcher.group(1) + matcher.group(2), value));
                if (this.versionStringComparator.compare(newestVersion, this.version) <= 0 || !(commonToolsDirectory = new File(value)).exists()) continue;
                this.version = newestVersion;
                this.home = commonToolsDirectory.getParentFile().getParentFile();
            }
        }
    }

    private void initWindowsSdk() throws MojoExecutionException {
        if (this.compareVersion(this.version, "8.0") <= 0) {
            String osArchitecture = NarUtil.getArchitecture(null);
            File VCINSTALLDIR = new File(this.home, "VC");
            this.legacySDK(new File(VCINSTALLDIR, "PlatformSDK"));
            File SDKIncludeDir = new File(VCINSTALLDIR.getAbsolutePath() + File.separator + "SDK" + File.separator + "v2.0", "include");
            this.sdkIncludes.add(SDKIncludeDir);
        } else {
            String kitVersion;
            File[] kitDirectories;
            if (this.windowsSdkVersion != null && this.windowsSdkVersion.trim().equals("")) {
                this.windowsSdkVersion = null;
            }
            this.mojo.getLog().debug((CharSequence)" -- Searching for usable WindowSDK ");
            for (File directory : Arrays.asList(new File("C:/Program Files (x86)/Windows Kits"), new File("C:/Program Files (x86)/Microsoft SDKs/Windows"), new File("C:/Program Files/Windows Kits"), new File("C:/Program Files/Microsoft SDKs/Windows"))) {
                if (!directory.exists()) continue;
                kitDirectories = directory.listFiles();
                Arrays.sort(kitDirectories, this.versionComparator);
                if (kitDirectories == null) continue;
                for (File kitDirectory : kitDirectories) {
                    if (!new File(kitDirectory, "Include").exists()) continue;
                    kitVersion = kitDirectory.getName();
                    if (kitVersion.charAt(0) == 'v') {
                        kitVersion = kitVersion.substring(1);
                    }
                    if (this.windowsSdkVersion != null && this.compareVersion(kitVersion, this.windowsSdkVersion) != 0) continue;
                    this.mojo.getLog().debug((CharSequence)String.format(" WindowSDK %1s found %2s", kitVersion, kitDirectory.getAbsolutePath()));
                    if (kitVersion.matches("\\d+\\.\\d+?[A-Z]?")) {
                        this.legacySDK(kitDirectory);
                        continue;
                    }
                    if (!kitVersion.matches("\\d+?")) continue;
                    this.addNewSDKLibraries(kitDirectory);
                }
                if (this.libsRequired.size() != 0) continue;
                break;
            }
            if (!this.foundSDK) {
                for (File directory : Arrays.asList(new File("C:/Program Files (x86)/Windows Kits"), new File("C:/Program Files (x86)/Microsoft SDKs/Windows"), new File("C:/Program Files/Windows Kits"), new File("C:/Program Files/Microsoft SDKs/Windows"))) {
                    if (!directory.exists()) continue;
                    kitDirectories = directory.listFiles();
                    Arrays.sort(kitDirectories, this.versionComparator);
                    if (kitDirectories == null) continue;
                    for (File kitDirectory : kitDirectories) {
                        if (!new File(kitDirectory, "Include").exists()) continue;
                        kitVersion = kitDirectory.getName();
                        if (kitVersion.charAt(0) == 'v') {
                            kitVersion = kitVersion.substring(1);
                        }
                        if (this.windowsSdkVersion != null && this.compareVersion(kitVersion, this.windowsSdkVersion) > 0) continue;
                        this.mojo.getLog().debug((CharSequence)String.format(" WindowSDK %1s found %2s", kitVersion, kitDirectory.getAbsolutePath()));
                        if (kitVersion.matches("\\d+\\.\\d+?[A-Z]?")) {
                            this.legacySDK(kitDirectory);
                            continue;
                        }
                        if (!kitVersion.matches("\\d+?")) continue;
                        this.addNewSDKLibraries(kitDirectory);
                    }
                    if (this.libsRequired.size() != 0) continue;
                    break;
                }
            }
        }
        if (!this.foundSDK) {
            throw new MojoExecutionException("msvc.windowsSdkVersion not specified and versions cannot be found");
        }
        this.mojo.getLog().debug((CharSequence)String.format(" Using WindowSDK %1s found %2s", this.windowsSdkVersion, this.windowsSdkHome));
    }

    private void addNewSDKLibraries(File kitDirectory) {
        List<File> kitVersionDirectories = Arrays.asList(new File(kitDirectory, "Include").listFiles());
        Collections.sort(kitVersionDirectories, this.versionComparator);
        ListIterator<File> kitVersionDirectoriesIt = kitVersionDirectories.listIterator();
        File kitVersionDirectory = null;
        while (kitVersionDirectoriesIt.hasNext() && (kitVersionDirectory = kitVersionDirectoriesIt.next()) != null && !new File(kitVersionDirectory, "ucrt").exists()) {
        }
        if (kitVersionDirectory != null) {
            String version = kitVersionDirectory.getName();
            this.mojo.getLog().debug((CharSequence)String.format(" Latest Win %1s KitDir at %2s", kitVersionDirectory.getName(), kitVersionDirectory.getAbsolutePath()));
            File includeDir = new File(kitDirectory, "Include/" + version);
            File libDir = new File(kitDirectory, "Lib/" + version);
            this.windowsSdkVersion = version;
            this.addSDKLibs(includeDir, libDir);
            this.setKit(kitDirectory);
        }
    }

    private void setKit(File home) {
        if (!this.foundSDK) {
            if (this.windowsSdkVersion == null) {
                this.windowsSdkVersion = home.getName();
            }
            if (this.windowsSdkHome == null) {
                this.windowsSdkHome = home;
            }
            this.foundSDK = true;
        }
    }

    private void legacySDK(File kitDirectory) {
        File includeDir = new File(kitDirectory, "Include");
        File libDir = new File(kitDirectory, "Lib");
        if (includeDir.exists() && libDir.exists()) {
            File usableLibDir = null;
            for (File libSubDir : libDir.listFiles()) {
                File um = new File(libSubDir, "um");
                if (!um.exists()) continue;
                usableLibDir = libSubDir;
            }
            if (usableLibDir == null) {
                usableLibDir = libDir.listFiles()[0];
            }
            this.addSDKLibs(includeDir, usableLibDir);
            this.setKit(kitDirectory);
        }
    }

    private void addSDKLibs(File includeDir, File libdir) {
        File[] libs;
        for (File libIncludeDir : libs = includeDir.listFiles()) {
            if (!this.libsRequired.remove(libIncludeDir.getName())) continue;
            this.mojo.getLog().debug((CharSequence)String.format(" Using directory %1s for library %2s", libIncludeDir.getAbsolutePath(), libIncludeDir.getName()));
            this.sdkIncludes.add(libIncludeDir);
            this.sdkLibs.add(new File(libdir, libIncludeDir.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File VCToolHome() {
        if (this.compareVersion(this.version, "15.0") < 0) {
            return new File(this.home, "VC/");
        }
        File msvcversionFile = new File(this.home, "VC/Auxiliary/Build/Microsoft.VCToolsVersion.default.txt");
        String msvcversion = "14.10.25017";
        try {
            BufferedReader brTest = new BufferedReader(new FileReader(msvcversionFile));
            msvcversion = brTest.readLine().trim();
            brTest.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File(new File(this.home, "VC/Tools/MSVC"), msvcversion);
    }

    public int compareVersion(Object o1, Object o2) {
        String version1 = (String)o1;
        String version2 = (String)o2;
        VersionTokenizer tokenizer1 = new VersionTokenizer(version1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version2);
        int number1 = 0;
        int number2 = 0;
        String suffix1 = "";
        String suffix2 = "";
        while (tokenizer1.MoveNext()) {
            boolean empty2;
            if (!tokenizer2.MoveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.MoveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.MoveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.MoveNext());
            return 0;
        }
        return 0;
    }

    class VersionTokenizer {
        private final String _versionString;
        private final int _length;
        private int _position;
        private int _number;
        private String _suffix;
        private boolean _hasValue;

        public int getNumber() {
            return this._number;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public boolean hasValue() {
            return this._hasValue;
        }

        public VersionTokenizer(String versionString) {
            if (versionString == null) {
                throw new IllegalArgumentException("versionString is null");
            }
            this._versionString = versionString;
            this._length = versionString.length();
        }

        public boolean MoveNext() {
            char c;
            char c2;
            this._number = 0;
            this._suffix = "";
            this._hasValue = false;
            if (this._position >= this._length) {
                return false;
            }
            this._hasValue = true;
            while (this._position < this._length && (c2 = this._versionString.charAt(this._position)) >= '0' && c2 <= '9') {
                this._number = this._number * 10 + (c2 - 48);
                ++this._position;
            }
            int suffixStart = this._position;
            while (this._position < this._length && (c = this._versionString.charAt(this._position)) != '.') {
                ++this._position;
            }
            this._suffix = this._versionString.substring(suffixStart, this._position);
            if (this._position < this._length) {
                ++this._position;
            }
            return true;
        }
    }

    private static enum CrossCompilers {
        x86,
        x64,
        x86_x64,
        x86_arm,
        x64_x86,
        x64_arm;

    }
}

