/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractDependencyMojo;
import com.github.maven_nar.AttachedNarArtifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="nar-assembly", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class NarAssemblyMojo
extends AbstractDependencyMojo {
    @Override
    protected ScopeFilter getArtifactScopeFilter() {
        return new ScopeFilter("runtime", null);
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        List<AttachedNarArtifact> attachedNarArtifacts = this.getAttachedNarArtifacts(this.libraries);
        this.downloadAttachedNars(attachedNarArtifacts);
        attachedNarArtifacts = this.getAttachedNarArtifacts(this.libraries);
        this.unpackAttachedNars(attachedNarArtifacts);
        for (AttachedNarArtifact element : attachedNarArtifacts) {
            Artifact dependency = (Artifact)element;
            this.getLog().debug((CharSequence)("Assemble from " + dependency));
            dependency.isSnapshot();
            File srcDir = this.getLayout().getNarUnpackDirectory(this.getUnpackDirectory(), this.getNarManager().getNarFile(dependency));
            File dstDir = this.getTargetDirectory();
            try {
                FileUtils.mkdir((String)dstDir.getPath());
                this.getLog().debug((CharSequence)("SrcDir: " + srcDir));
                if (!srcDir.exists()) continue;
                FileUtils.copyDirectoryStructureIfModified((File)srcDir, (File)dstDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to copy directory for dependency " + dependency + " from " + srcDir + " to " + dstDir, (Exception)ioe);
            }
        }
    }
}

