/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.Script;
import com.github.maven_nar.Substitution;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;

@Mojo(name="nar-prepare-package", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NarPreparePackageMojo
extends AbstractCompileMojo {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        this.getLayout().prepareNarInfo(this.getTargetDirectory(), this.getMavenProject(), this.getNarInfo(), this);
        this.getNarInfo().writeToDirectory(this.classesDirectory);
        final String artifactIdVersion = this.getMavenProject().getArtifactId() + "-" + this.getMavenProject().getVersion();
        File[] files = this.getTargetDirectory().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(artifactIdVersion) && !file.getName().endsWith("noarch");
            }
        });
        this.getNarInfo().writeToDirectory(files);
        if (this.replay == null || this.replay.getScripts() == null || this.replay.getScripts().isEmpty()) return;
        File compileCommandsInFile = new File(this.replay.getOutputDirectory(), "compile-commands");
        File linkCommandsInputInFile = new File(this.replay.getOutputDirectory(), "link-commands");
        File testCompileCommandsInFile = new File(this.replay.getOutputDirectory(), "test-compile-commands");
        File testLinkCommandsInFile = new File(this.replay.getOutputDirectory(), "test-link-commands");
        try {
            List<String> compileCommands = Files.readAllLines(compileCommandsInFile.toPath());
            List<String> linkCommands = Files.readAllLines(linkCommandsInputInFile.toPath());
            List<String> testCompileCommands = null;
            List<String> testLinkCommands = null;
            if (!this.skipTests) {
                testCompileCommands = Files.readAllLines(testCompileCommandsInFile.toPath());
                testLinkCommands = Files.readAllLines(testLinkCommandsInFile.toPath());
            }
            for (Script script : this.replay.getScripts()) {
                File scriptFile = new File(this.replay.getScriptDirectory(), script.getId() + "." + script.getExtension());
                try {
                    PrintWriter writer = new PrintWriter(new FileWriter(scriptFile));
                    Throwable throwable = null;
                    try {
                        for (String header : script.getHeaders()) {
                            writer.println(header);
                        }
                        if (script.isCompile()) {
                            writer.println();
                            this.processReplayFile(compileCommands, script, writer);
                            this.getLog().info((CharSequence)("Wrote compile commands to file: " + scriptFile));
                        }
                        if (script.isLink()) {
                            writer.println();
                            this.processReplayFile(linkCommands, script, writer);
                            this.getLog().info((CharSequence)("Wrote link commands to file: " + scriptFile));
                        }
                        if (script.testCompile && !this.skipTests) {
                            writer.println();
                            this.processReplayFile(testCompileCommands, script, writer);
                            this.getLog().info((CharSequence)("Wrote test compile commands to file: " + scriptFile));
                        }
                        if (script.isTestLink() && !this.skipTests) {
                            writer.println();
                            this.processReplayFile(testLinkCommands, script, writer);
                            this.getLog().info((CharSequence)("Wrote test link commands to file: " + scriptFile));
                        }
                        for (String footer : script.getFooters()) {
                            writer.println(footer);
                        }
                        Set<PosixFilePermission> perms = NarUtil.parseOctalPermission(script.getMode());
                        Files.setPosixFilePermissions(scriptFile.toPath(), perms);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write replay script to " + scriptFile, (Exception)e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read command history", (Exception)e);
        }
    }

    public void processReplayFile(List<String> lines, Script script, PrintWriter writer) throws MojoExecutionException {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            String processed = line = iterator.next();
            if (script.getSubstitutions() != null) {
                for (Substitution sub : script.getSubstitutions()) {
                    processed = sub.substitute(processed);
                }
            }
            if (script.isEchoLines()) {
                writer.print("echo ");
                writer.println(processed);
            }
            writer.println(processed);
        }
    }

    @Override
    protected ScopeFilter getArtifactScopeFilter() {
        return new ScopeFilter("compile", null);
    }
}

