/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractResourcesMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

@Mojo(name="nar-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public class NarResourcesMojo
extends AbstractResourcesMojo {
    @Parameter(property="nar.resources.copy.aol", defaultValue="true", required=true)
    private boolean resourcesCopyAOL;
    @Parameter(defaultValue="${basedir}/src/nar/resources", required=true)
    private File resourceDirectory;

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        try {
            int copied = 0;
            File noarchDir = new File(this.resourceDirectory, "noarch");
            if (noarchDir.exists()) {
                File noarchDstDir = this.getLayout().getNoArchDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion());
                this.getLog().debug((CharSequence)("Copying noarch from " + noarchDir + " to " + noarchDstDir));
                copied += NarUtil.copyDirectoryStructure(noarchDir, noarchDstDir, null, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
            }
            this.getLog().info((CharSequence)("Copied " + copied + " resources"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("NAR: Could not copy resources", (Exception)e);
        }
        File aolDir = new File(this.resourceDirectory, "aol");
        if (aolDir.exists()) {
            String[] aol;
            for (String anAol : aol = aolDir.list()) {
                if (this.resourcesCopyAOL && !anAol.equals(this.getAOL().toString())) continue;
                boolean ignore = false;
                for (Object element : FileUtils.getDefaultExcludesAsList()) {
                    String exclude = (String)element;
                    if (!SelectorUtils.matchPath((String)exclude.replace('/', File.separatorChar), (String)anAol)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                File aolFile = new File(aolDir, anAol);
                this.copyResources(aolFile, aolFile.getName());
            }
        }
        this.createReplayDirs();
    }
}

