/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import java.io.File;
import java.util.regex.Pattern;

public class Substitution {
    private static final String[] types = new String[]{"string", "relativePath", "absolutePath", "regex"};
    private Pattern pattern;
    protected String type = "string";
    protected String replace;
    protected String replaceWith = "";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public String getReplaceWith() {
        return this.replaceWith;
    }

    public void setReplaceWith(String replaceWith) {
        this.replaceWith = replaceWith;
    }

    public String substitute(String line) {
        if (this.replace == null) {
            return line;
        }
        String temp = this.replace;
        if (this.type.equals("regex")) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.replace);
            }
            return this.pattern.matcher(line).replaceAll(this.replaceWith);
        }
        if (this.type.equals("relativePath")) {
            temp = new File(this.replace).getPath() + File.separator;
        } else if (this.type.equals("absolutePath")) {
            temp = new File(this.replace).getAbsolutePath() + File.separator;
        }
        return line.replace(temp, this.replaceWith);
    }
}

