/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CompilerEnum;
import com.github.maven_nar.cpptasks.CompilerParam;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.PrecompileDef;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.WarningLevelEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.Compiler;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.gcc.GccCCompiler;
import com.github.maven_nar.cpptasks.types.CompilerArgument;
import com.github.maven_nar.cpptasks.types.ConditionalPath;
import com.github.maven_nar.cpptasks.types.DefineSet;
import com.github.maven_nar.cpptasks.types.IncludePath;
import com.github.maven_nar.cpptasks.types.SystemIncludePath;
import com.github.maven_nar.cpptasks.types.UndefineArgument;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public final class CompilerDef
extends ProcessorDef {
    private final Vector defineSets = new Vector();
    private Boolean ccache = false;
    private Boolean exceptions;
    private Boolean rtti;
    private final Vector includePaths = new Vector();
    private Boolean multithreaded;
    private final Vector precompileDefs = new Vector();
    private final Vector sysIncludePaths = new Vector();
    private OptimizationEnum optimization;
    private int warnings = -1;
    private List<String> order;
    private String toolPath;
    private String compilerPrefix;
    private File workDir;
    private boolean gccFileAbsolutePath;
    private String fortifyID = "";
    private List<String[]> commands;
    private boolean dryRun;
    private boolean clearDefaultOptions;

    public void addConfiguredCompilerArg(CompilerArgument arg) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.addConfiguredProcessorArg(arg);
    }

    public void addConfiguredCompilerParam(CompilerParam param) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.addConfiguredProcessorParam(param);
    }

    public void addConfiguredDefineset(DefineSet defs) {
        if (defs == null) {
            throw new NullPointerException("defs");
        }
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.defineSets.addElement(defs);
    }

    public IncludePath createIncludePath() {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project must be set");
        }
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        IncludePath path = new IncludePath(p);
        this.includePaths.addElement(path);
        return path;
    }

    public PrecompileDef createPrecompile() throws BuildException {
        Project p = this.getProject();
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PrecompileDef precomp = new PrecompileDef();
        precomp.setProject(p);
        this.precompileDefs.addElement(precomp);
        return precomp;
    }

    public SystemIncludePath createSysIncludePath() {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project must be set");
        }
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        SystemIncludePath path = new SystemIncludePath(p);
        this.sysIncludePaths.addElement(path);
        return path;
    }

    public void execute() throws BuildException {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public UndefineArgument[] getActiveDefines() {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project must be set before this call");
        }
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getActiveDefines();
        }
        Vector<UndefineArgument> actives = new Vector<UndefineArgument>();
        for (int i = 0; i < this.defineSets.size(); ++i) {
            UndefineArgument[] defines;
            DefineSet currentSet = (DefineSet)((Object)this.defineSets.elementAt(i));
            for (UndefineArgument define : defines = currentSet.getDefines()) {
                if (!define.isActive(p)) continue;
                actives.addElement(define);
            }
        }
        Object[] retval = new UndefineArgument[actives.size()];
        actives.copyInto(retval);
        return retval;
    }

    public String[] getActiveIncludePaths() {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getActiveIncludePaths();
        }
        return this.getActivePaths(this.includePaths);
    }

    private String[] getActivePaths(Vector paths) {
        Project p = this.getProject();
        if (p == null) {
            throw new IllegalStateException("project not set");
        }
        Vector<String> activePaths = new Vector<String>(paths.size());
        for (int i = 0; i < paths.size(); ++i) {
            String[] pathEntries;
            ConditionalPath path = (ConditionalPath)((Object)paths.elementAt(i));
            if (!path.isActive(p)) continue;
            for (String pathEntrie : pathEntries = path.list()) {
                activePaths.addElement(pathEntrie);
            }
        }
        Object[] pathNames = new String[activePaths.size()];
        activePaths.copyInto(pathNames);
        return pathNames;
    }

    public PrecompileDef getActivePrecompile(CompilerDef ccElement) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getActivePrecompile(ccElement);
        }
        PrecompileDef current = null;
        Enumeration iter = this.precompileDefs.elements();
        while (iter.hasMoreElements()) {
            current = (PrecompileDef)((Object)iter.nextElement());
            if (!current.isActive()) continue;
            return current;
        }
        CompilerDef extendedDef = (CompilerDef)this.getExtends();
        if (extendedDef != null && (current = extendedDef.getActivePrecompile(null)) != null) {
            return current;
        }
        if (ccElement != null && this.getInherit()) {
            return ccElement.getActivePrecompile(null);
        }
        return null;
    }

    public String[] getActiveSysIncludePaths() {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getActiveSysIncludePaths();
        }
        return this.getActivePaths(this.sysIncludePaths);
    }

    public Boolean getCcache() {
        return this.ccache;
    }

    public final boolean getExceptions(CompilerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getExceptions(defaultProviders, index);
        }
        if (this.exceptions != null) {
            return this.exceptions;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getExceptions(defaultProviders, index + 1);
        }
        return false;
    }

    public boolean getMultithreaded(CompilerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getMultithreaded(defaultProviders, index);
        }
        if (this.multithreaded != null) {
            return this.multithreaded;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getMultithreaded(defaultProviders, index + 1);
        }
        return true;
    }

    public final OptimizationEnum getOptimization(CompilerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getOptimization(defaultProviders, index);
        }
        if (this.optimization != null) {
            return this.optimization;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getOptimization(defaultProviders, index + 1);
        }
        return null;
    }

    public List<String> getOrder() {
        return this.order;
    }

    @Override
    public Processor getProcessor() {
        Processor processor = super.getProcessor();
        if (processor == null) {
            processor = GccCCompiler.getInstance();
        }
        if (this.getLibtool() && processor instanceof CommandLineCompiler) {
            CommandLineCompiler compiler = (CommandLineCompiler)processor;
            processor = compiler.getLibtoolCompiler();
        }
        return processor;
    }

    public final Boolean getRtti(CompilerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getRtti(defaultProviders, index);
        }
        if (this.rtti != null) {
            return this.rtti;
        }
        if (defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getRtti(defaultProviders, index + 1);
        }
        return null;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public String getCompilerPrefix() {
        return this.compilerPrefix;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public int getWarnings(CompilerDef[] defaultProviders, int index) {
        if (this.isReference()) {
            return ((CompilerDef)((Object)this.getCheckedRef(CompilerDef.class, "CompilerDef"))).getWarnings(defaultProviders, index);
        }
        if (this.warnings == -1 && defaultProviders != null && index < defaultProviders.length) {
            return defaultProviders[index].getWarnings(defaultProviders, index + 1);
        }
        return this.warnings;
    }

    public boolean isClearDefaultOptions() {
        return this.clearDefaultOptions;
    }

    public void setCcache(Boolean ccache) {
        this.ccache = ccache;
    }

    @Override
    public void setClassname(String classname) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        super.setClassname(classname);
        Processor proc = this.getProcessor();
        if (!(proc instanceof Compiler)) {
            throw new BuildException(classname + " does not implement Compiler");
        }
    }

    public void setClearDefaultOptions(boolean clearDefaultOptions) {
        this.clearDefaultOptions = clearDefaultOptions;
    }

    public void setExceptions(boolean exceptions) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.exceptions = CompilerDef.booleanValueOf(exceptions);
    }

    public void setMultithreaded(boolean multithreaded) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.multithreaded = CompilerDef.booleanValueOf(multithreaded);
    }

    public void setName(CompilerEnum name) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Compiler compiler = name.getCompiler();
        this.setProcessor(compiler);
    }

    public void setOptimize(OptimizationEnum value) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.optimization = value;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    @Override
    protected void setProcessor(Processor proc) throws BuildException {
        try {
            super.setProcessor(proc);
        }
        catch (ClassCastException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void setRtti(boolean rtti) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.rtti = CompilerDef.booleanValueOf(rtti);
    }

    public void setToolPath(String path) {
        this.toolPath = path;
    }

    public void setCompilerPrefix(String prefix) {
        this.compilerPrefix = prefix;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setFortifyID(String fortifyID) {
        this.fortifyID = fortifyID;
    }

    public String getFortifyID() {
        return this.fortifyID;
    }

    public void setWarnings(WarningLevelEnum level) {
        this.warnings = level.getIndex();
    }

    public void setGccFileAbsolutePath(boolean sourceFileAbsPath) {
        this.gccFileAbsolutePath = sourceFileAbsPath;
    }

    public boolean getGccFileAbsolutePath() {
        return this.gccFileAbsolutePath;
    }

    public List<String[]> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String[]> commands) {
        this.commands = commands;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }
}

