/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.borland.BorlandLinker;
import com.github.maven_nar.cpptasks.borland.BorlandProcessor;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class BorlandLibrarian
extends CommandLineLinker {
    private static final BorlandLibrarian instance = new BorlandLibrarian();

    public static BorlandLibrarian getInstance() {
        return instance;
    }

    private BorlandLibrarian() {
        super("tlib", "--version", new String[]{".obj"}, new String[0], ".lib", false, null);
    }

    @Override
    protected String getCommandFileSwitch(String cmdFile) {
        StringBuffer buf = new StringBuffer("@");
        BorlandProcessor.quoteFile(buf, cmdFile);
        return buf.toString();
    }

    @Override
    public String getIdentifier() {
        return "TLIB 4.5 Copyright (c) 1987, 1999 Inprise Corporation";
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return BorlandProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public String[] getOutputFileSwitch(String outFile) {
        return BorlandProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    public boolean isCaseSensitive() {
        return BorlandProcessor.isCaseSensitive();
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        outputFile.delete();
        super.link(task, outputFile, sourceFiles, config);
    }

    @Override
    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        StringBuffer buf = new StringBuffer();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement(this.quoteFilename(buf, outputFileName));
        for (String prearg : preargs) {
            execArgs.addElement(prearg);
        }
        int pageSizeIndex = execArgs.size();
        execArgs.addElement(null);
        int objBytes = 0;
        for (String sourceFile : sourceFiles) {
            String last4 = sourceFile.substring(sourceFile.length() - 4).toLowerCase();
            if (last4.equals(".def") || last4.equals(".res") || last4.equals(".lib")) continue;
            execArgs.addElement("+" + this.quoteFilename(buf, sourceFile));
            objBytes = (int)((long)objBytes + new File(sourceFile).length());
        }
        for (String endarg : endargs) {
            execArgs.addElement(endarg);
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        int minPageSize = objBytes >> 16;
        int pageSize = 0;
        for (int i = 4; i <= 15 && (pageSize = 1 << i) <= minPageSize; ++i) {
        }
        execArguments[pageSizeIndex] = "/P" + Integer.toString(pageSize);
        return execArguments;
    }

    @Override
    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String[] cmdargs = BorlandProcessor.prepareResponseFile(outputFile, args, " & \n");
        cmdargs[cmdargs.length - 1] = this.getCommandFileSwitch(cmdargs[cmdargs.length - 1]);
        return cmdargs;
    }

    @Override
    protected String quoteFilename(StringBuffer buf, String filename) {
        buf.setLength(0);
        BorlandProcessor.quoteFile(buf, filename);
        return buf.toString();
    }
}

