/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.TargetMatcher;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.borland.BorlandLibrarian;
import com.github.maven_nar.cpptasks.borland.BorlandProcessor;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.platforms.WindowsPlatform;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class BorlandLinker
extends CommandLineLinker {
    private static final BorlandLinker dllLinker = new BorlandLinker(".dll");
    private static final BorlandLinker instance = new BorlandLinker(".exe");

    public static BorlandLinker getInstance() {
        return instance;
    }

    private BorlandLinker(String outputSuffix) {
        super("ilink32", "-r", new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk"}, outputSuffix, false, null);
    }

    protected void addBase(long base, Vector<String> args) {
        if (base >= 0L) {
            String baseAddr = Long.toHexString(base);
            args.addElement("-b:" + baseAddr);
        }
    }

    protected void addEntry(String entry, Vector<String> args) {
    }

    protected void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (linkType.isExecutable()) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("/ap");
            } else if (linkType.isSubsystemGUI()) {
                args.addElement("/Tpe");
            }
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/Tpd");
            args.addElement("/Gi");
        }
        if (debug) {
            args.addElement("-v");
        }
    }

    protected void addIncremental(boolean incremental, Vector<String> args) {
    }

    protected void addMap(boolean map, Vector<String> args) {
        if (!map) {
            args.addElement("-x");
        }
    }

    protected void addStack(int stack, Vector<String> args) {
        if (stack >= 0) {
            String stackStr = Integer.toHexString(stack);
            args.addElement("-S:" + stackStr);
        }
    }

    @Override
    public void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        WindowsPlatform.addVersionFiles(versionInfo, linkType, outputFile, isDebug, objDir, matcher);
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public String getIdentifier() {
        return "Borland Linker";
    }

    @Override
    public File[] getLibraryPath() {
        return BorlandProcessor.getEnvironmentPath("ilink32", 'L', new String[]{"..\\lib"});
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return BorlandProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return BorlandLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public String[] getOutputFileSwitch(String outFile) {
        return BorlandProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    protected String getStartupObject(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return "c0d32.obj";
        }
        if (linkType.isSubsystemGUI()) {
            return "c0w32.obj";
        }
        if (linkType.isSubsystemConsole()) {
            return "c0x32.obj";
        }
        return null;
    }

    @Override
    public boolean isCaseSensitive() {
        return BorlandProcessor.isCaseSensitive();
    }

    @Override
    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        for (String prearg : preargs) {
            execArgs.addElement(prearg);
        }
        for (String endarg : endargs) {
            execArgs.addElement(endarg);
        }
        String startup = null;
        for (String sourceFile : sourceFiles) {
            String[] filename = new File(sourceFile).getName().toLowerCase();
            if (startup == null || !filename.substring(0, 2).equals("c0") || !filename.substring(3, 5).equals("32") || !filename.substring(filename.length() - 4).equals(".obj")) continue;
            startup = sourceFile;
        }
        if (startup == null) {
            startup = config.getStartupObject();
        }
        execArgs.addElement(startup);
        Vector<String> resFiles = new Vector<String>();
        Vector<String> libFiles = new Vector<String>();
        String defFile = null;
        StringBuffer buf = new StringBuffer();
        for (String sourceFile : sourceFiles) {
            String last4 = sourceFile.substring(sourceFile.length() - 4).toLowerCase();
            if (last4.equals(".def")) {
                defFile = this.quoteFilename(buf, sourceFile);
                continue;
            }
            if (last4.equals(".res")) {
                resFiles.addElement(this.quoteFilename(buf, sourceFile));
                continue;
            }
            if (last4.equals(".lib")) {
                libFiles.addElement(this.quoteFilename(buf, sourceFile));
                continue;
            }
            execArgs.addElement(this.quoteFilename(buf, sourceFile));
        }
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement("," + this.quoteFilename(buf, outputFileName));
        if (config.getMap()) {
            int lastPeriod = outputFileName.lastIndexOf(46);
            String mapName = lastPeriod < outputFileName.length() - 4 ? outputFileName + ".map" : outputFileName.substring(0, lastPeriod) + ".map";
            execArgs.addElement("," + this.quoteFilename(buf, mapName) + ",");
        } else {
            execArgs.addElement(",,");
        }
        Enumeration libEnum = libFiles.elements();
        boolean hasImport32 = false;
        boolean hasCw32 = false;
        while (libEnum.hasMoreElements()) {
            String libName = (String)libEnum.nextElement();
            if (libName.equalsIgnoreCase("import32.lib")) {
                hasImport32 = true;
            }
            if (libName.equalsIgnoreCase("cw32.lib")) {
                hasImport32 = true;
            }
            execArgs.addElement(this.quoteFilename(buf, libName));
        }
        execArgs.addElement(this.quoteFilename(buf, "cw32.lib"));
        if (!hasImport32) {
            execArgs.addElement(this.quoteFilename(buf, "import32.lib"));
        }
        if (defFile == null) {
            execArgs.addElement(",,");
        } else {
            execArgs.addElement("," + this.quoteFilename(buf, defFile) + ",");
        }
        Enumeration resEnum = resFiles.elements();
        while (resEnum.hasMoreElements()) {
            String resName = (String)resEnum.nextElement();
            execArgs.addElement(this.quoteFilename(buf, resName));
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        return execArguments;
    }

    @Override
    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String[] cmdargs = BorlandProcessor.prepareResponseFile(outputFile, args, " + \n");
        cmdargs[cmdargs.length - 1] = this.getCommandFileSwitch(cmdargs[cmdargs.length - 1]);
        return cmdargs;
    }
}

