/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.ProcessorParam;
import com.github.maven_nar.cpptasks.TargetDef;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.AbstractLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.LinkerConfiguration;
import com.github.maven_nar.cpptasks.types.CommandLineArgument;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineLinker
extends AbstractLinker {
    private String command;
    private String prefix;
    private Environment env = null;
    private String identifier;
    private final String identifierArg;
    private final boolean isLibtool;
    private String[] librarySets;
    private final CommandLineLinker libtoolLinker;
    private final boolean newEnvironment = false;
    private final String outputSuffix;
    private List<String[]> commands;
    private boolean dryRun;
    private final int maxPathLength = 250;

    public CommandLineLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputSuffix, boolean isLibtool, CommandLineLinker libtoolLinker) {
        super(extensions, ignoredExtensions);
        this.command = command;
        this.identifierArg = identifierArg;
        this.outputSuffix = outputSuffix;
        this.isLibtool = isLibtool;
        this.libtoolLinker = libtoolLinker;
    }

    protected void addBase(CCTask task, long base, Vector<String> args) {
    }

    protected void addEntry(CCTask task, String entry, Vector<String> args) {
    }

    protected void addFixed(CCTask task, Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(CCTask task, boolean debug, LinkType linkType, Vector<String> args) {
    }

    protected void addIncremental(CCTask task, boolean incremental, Vector<String> args) {
    }

    protected void addLibraryDirectory(File libraryDirectory, Vector<String> preargs) {
        try {
            if (libraryDirectory != null && libraryDirectory.exists()) {
                File currentDir = new File(".").getParentFile();
                String path = libraryDirectory.getCanonicalPath();
                if (currentDir != null) {
                    String currentPath = currentDir.getCanonicalPath();
                    path = CUtil.getRelativePath(currentPath, libraryDirectory);
                }
                this.addLibraryPath(preargs, path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to add library path: " + libraryDirectory);
        }
    }

    protected void addLibraryPath(Vector<String> preargs, String path) {
    }

    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector<String> preargs, Vector<String> midargs, Vector<String> endargs) {
        return null;
    }

    protected void addMap(CCTask task, boolean map, Vector<String> args) {
    }

    protected void addStack(CCTask task, int stack, Vector<String> args) {
    }

    @Override
    protected LinkerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, LinkerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        ProcessorParam[] paramArray;
        Vector<String> preargs = new Vector<String>();
        Vector<String> midargs = new Vector<String>();
        Vector<String> endargs = new Vector<String>();
        Vector[] args = new Vector[]{preargs, midargs, endargs};
        this.prefix = specificDef.getLinkerPrefix();
        LinkerDef[] defaultProviders = new LinkerDef[baseDefs.length + 1];
        defaultProviders[0] = specificDef;
        for (int i = 0; i < baseDefs.length; ++i) {
            defaultProviders[i + 1] = (LinkerDef)baseDefs[i];
        }
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            CommandLineArgument[] commandArgs;
            LinkerDef linkerDef = defaultProviders[i];
            for (CommandLineArgument commandArg : commandArgs = linkerDef.getActiveProcessorArgs()) {
                args[commandArg.getLocation()].addElement(commandArg.getValue());
            }
        }
        LinkedHashSet<File> libraryDirectories = new LinkedHashSet<File>();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            LinkerDef linkerDef = defaultProviders[i];
            for (File libraryDirectory : linkerDef.getLibraryDirectories()) {
                if (!libraryDirectories.add(libraryDirectory)) continue;
                this.addLibraryDirectory(libraryDirectory, preargs);
            }
        }
        Vector params = new Vector();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            paramArray = defaultProviders[i].getActiveProcessorParams();
            Collections.addAll(params, paramArray);
        }
        paramArray = params.toArray(new ProcessorParam[params.size()]);
        boolean debug = specificDef.getDebug(baseDefs, 0);
        String startupObject = this.getStartupObject(linkType);
        this.addImpliedArgs(task, debug, linkType, preargs);
        this.addIncremental(task, specificDef.getIncremental(defaultProviders, 1), preargs);
        this.addFixed(task, specificDef.getFixed(defaultProviders, 1), preargs);
        this.addMap(task, specificDef.getMap(defaultProviders, 1), preargs);
        this.addBase(task, specificDef.getBase(defaultProviders, 1), preargs);
        this.addStack(task, specificDef.getStack(defaultProviders, 1), preargs);
        this.addEntry(task, specificDef.getEntry(defaultProviders, 1), preargs);
        String[] libnames = null;
        LibrarySet[] libsets = specificDef.getActiveLibrarySets(defaultProviders, 1);
        libnames = this.addLibrarySets(task, libsets, preargs, midargs, endargs);
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        for (int i = 0; i < 3; ++i) {
            Enumeration argenum = args[i].elements();
            while (argenum.hasMoreElements()) {
                buf.append(' ');
                buf.append((String)argenum.nextElement());
            }
        }
        String configId = buf.toString();
        String[][] options = new String[][]{new String[args[0].size() + args[1].size()], new String[args[2].size()]};
        args[0].copyInto(options[0]);
        int offset = args[0].size();
        for (int i = 0; i < args[1].size(); ++i) {
            options[0][i + offset] = (String)args[1].elementAt(i);
        }
        args[2].copyInto(options[1]);
        if (null != specificDef.getEnv() && null == this.env) {
            this.env = specificDef.getEnv();
        }
        for (ProcessorDef processorDef : baseDefs) {
            Environment environment = processorDef.getEnv();
            if (null == environment || null != this.env) continue;
            this.env = environment;
        }
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        boolean map = specificDef.getMap(defaultProviders, 1);
        String toolPath = specificDef.getToolPath();
        this.setCommands(specificDef.getCommands());
        this.setDryRun(specificDef.isDryRun());
        return new CommandLineLinkerConfiguration(this, configId, options, paramArray, rebuild, map, debug, libnames, startupObject, toolPath);
    }

    protected String decorateLinkerOption(StringBuffer buf, String arg) {
        return arg;
    }

    protected final String getCommand() {
        if (this.prefix != null && !this.prefix.isEmpty()) {
            return this.prefix + this.command;
        }
        return this.command;
    }

    protected abstract String getCommandFileSwitch(String var1);

    public String getCommandWithPath(CommandLineLinkerConfiguration config) {
        if (config.getCommandPath() != null) {
            File command = new File(config.getCommandPath(), this.getCommand());
            try {
                return command.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return command.getAbsolutePath();
            }
        }
        return this.getCommand();
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? CommandLineLinker.getIdentifier(new String[]{this.getCommand()}, this.getCommand()) : CommandLineLinker.getIdentifier(new String[]{this.getCommand(), this.identifierArg}, this.getCommand());
        }
        return this.identifier;
    }

    public final CommandLineLinker getLibtoolLinker() {
        if (this.libtoolLinker != null) {
            return this.libtoolLinker;
        }
        return this;
    }

    protected abstract int getMaximumCommandLength();

    @Override
    public String[] getOutputFileNames(String baseName, VersionInfo versionInfo) {
        return new String[]{baseName + this.outputSuffix};
    }

    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        if (this.isWindows() && outputFile.length() > this.maxPathLength) {
            throw new BuildException("Absolute path too long, " + outputFile.length() + " > " + this.maxPathLength + ": '" + outputFile);
        }
        return this.getOutputFileSwitch(outputFile);
    }

    protected abstract String[] getOutputFileSwitch(String var1);

    protected String getStartupObject(LinkType linkType) {
        return null;
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int retval;
        String parentPath;
        File parentDir = new File(outputFile.getParent());
        try {
            parentPath = parentDir.getCanonicalPath();
        }
        catch (IOException ex) {
            parentPath = parentDir.getAbsolutePath();
        }
        String[] execArgs = this.prepareArguments(task, parentPath, outputFile.getName(), sourceFiles, config);
        int commandLength = 0;
        for (String execArg : execArgs) {
            commandLength += execArg.length() + 1;
        }
        if (commandLength >= this.getMaximumCommandLength()) {
            try {
                execArgs = this.prepareResponseFile(outputFile, execArgs);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if ((retval = this.runCommand(task, parentDir, execArgs)) != 0) {
            throw new BuildException(this.getCommandWithPath(config) + " failed with return code " + retval, task.getLocation());
        }
    }

    protected String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        String[] outputSwitch = this.getOutputFileSwitch(task, outputFile);
        int allArgsCount = preargs.length + 1 + outputSwitch.length + sourceFiles.length + endargs.length;
        if (this.isLibtool) {
            ++allArgsCount;
        }
        String[] allArgs = new String[allArgsCount];
        int index = 0;
        if (this.isLibtool) {
            allArgs[index++] = "libtool";
        }
        allArgs[index++] = this.getCommandWithPath(config);
        StringBuffer buf = new StringBuffer();
        for (String prearg : preargs) {
            allArgs[index++] = task.isDecorateLinkerOptions() ? this.decorateLinkerOption(buf, prearg) : prearg;
        }
        for (String element : outputSwitch) {
            allArgs[index++] = element;
        }
        for (String sourceFile : sourceFiles) {
            allArgs[index++] = this.prepareFilename(buf, outputDir, sourceFile);
        }
        for (String endarg : endargs) {
            allArgs[index++] = task.isDecorateLinkerOptions() ? this.decorateLinkerOption(buf, endarg) : endarg;
        }
        return allArgs;
    }

    protected String prepareFilename(StringBuffer buf, String outputDir, String sourceFile) {
        if (this.isWindows() && sourceFile.length() > this.maxPathLength) {
            throw new BuildException("Absolute path too long, " + sourceFile.length() + " > " + this.maxPathLength + ": '" + sourceFile);
        }
        return this.quoteFilename(buf, sourceFile);
    }

    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String baseName = outputFile.getName();
        File commandFile = new File(outputFile.getParent(), baseName + ".rsp");
        FileWriter writer = new FileWriter(commandFile);
        int execArgCount = 1;
        if (this.isLibtool) {
            ++execArgCount;
        }
        String[] execArgs = new String[execArgCount + 1];
        System.arraycopy(args, 0, execArgs, 0, execArgCount);
        execArgs[execArgCount] = this.getCommandFileSwitch(commandFile.toString());
        for (int i = execArgCount; i < args.length; ++i) {
            if (args[i].contains(" ") && args[i].charAt(0) != '\"') {
                writer.write(34);
                writer.write(args[i]);
                writer.write("\"\n");
                continue;
            }
            writer.write(args[i]);
            writer.write(10);
        }
        writer.close();
        return execArgs;
    }

    protected String quoteFilename(StringBuffer buf, String filename) {
        if (filename.indexOf(32) >= 0) {
            buf.setLength(0);
            buf.append('\"');
            buf.append(filename);
            buf.append('\"');
            return buf.toString();
        }
        return filename;
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        this.commands.add(cmdline);
        if (this.dryRun) {
            return 0;
        }
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    protected final void setCommand(String command) {
        this.command = command;
    }

    public void setCommands(List<String[]> commands) {
        this.commands = commands;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }
}

