/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.msvc.MsvcLinker;
import com.github.maven_nar.cpptasks.msvc.MsvcProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class Assembler64bitCompiler
extends CommandLineCompiler {
    private static final Assembler64bitCompiler instance = new Assembler64bitCompiler(false, null);
    private String identifier;

    public static Assembler64bitCompiler getInstance() {
        return instance;
    }

    private Assembler64bitCompiler(boolean newEnvironment, Environment env) {
        super("ml64", null, new String[]{".asm"}, new String[0], ".obj", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("/c");
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new Assembler64bitCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        MsvcProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return MsvcProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            String fullOutputName = new File(outputDir, outputFileName).toString();
            return "/Fo" + fullOutputName;
        }
        return filename;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return MsvcLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 32000;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 2;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        MsvcProcessor.getUndefineSwitch(buffer, define);
    }

    @Override
    public String getIdentifier() {
        return "Microsoft (R) Macro Assembler (x64)";
    }

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector args, Vector relativeArgs, StringBuffer includePathId, boolean isSystem) {
    }
}

