/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.TargetDef;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.msvc.MsvcLinker;
import com.github.maven_nar.cpptasks.msvc.MsvcProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class MsvcMIDLCompiler
extends CommandLineCompiler {
    private static final MsvcMIDLCompiler instance = new MsvcMIDLCompiler(false, null);

    public static MsvcMIDLCompiler getInstance() {
        return instance;
    }

    private MsvcMIDLCompiler(boolean newEnvironment, Environment env) {
        super("midl", null, new String[]{".idl", ".odl"}, new String[0], ".tlb", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
        MsvcProcessor.addWarningSwitch(args, level);
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new MsvcMIDLCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected CompilerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, CompilerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        return new CommandLineCompilerConfiguration((CommandLineCompilerConfiguration)super.createConfiguration(task, linkType, baseDefs, specificDef, targetPlatform, versionInfo), null, null, true);
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 5;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        MsvcProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return MsvcProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        if (this.bid(inputFile) > 1) {
            String baseName = this.getBaseOutputName(inputFile);
            return new String[]{baseName + this.getOutputSuffix()};
        }
        return new String[0];
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        switch (index) {
            case 0: {
                return "/tlb";
            }
            case 1: {
                return new File(outputDir, this.getOutputFileNames(filename, null)[0]).getAbsolutePath();
            }
            case 2: {
                return "/out";
            }
            case 3: {
                return outputDir.getAbsolutePath();
            }
        }
        return filename;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return MsvcLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 32000;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        MsvcProcessor.getUndefineSwitch(buffer, define);
    }
}

