/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import com.github.maven_nar.cpptasks.ide.CommentDef;
import com.github.maven_nar.cpptasks.ide.DependencyDef;
import com.github.maven_nar.cpptasks.ide.ProjectDef;
import com.github.maven_nar.cpptasks.ide.ProjectWriter;
import com.github.maven_nar.cpptasks.msvc.MsvcCCompiler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;

public final class MsvcProjectWriter
implements ProjectWriter {
    private final String version;

    private static String toProjectName(String name) {
        StringBuffer projectNameBuf = new StringBuffer(name);
        for (int i = 0; i < projectNameBuf.length(); ++i) {
            char ch = projectNameBuf.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') continue;
            projectNameBuf.setCharAt(i, '_');
        }
        return projectNameBuf.toString();
    }

    private static void writeComments(Writer writer, List<CommentDef> comments) throws IOException {
        for (CommentDef commentDef : comments) {
            String comment = commentDef.getText();
            if (comment == null) continue;
            int start = 0;
            int end = comment.indexOf(10);
            while (end != -1) {
                writer.write("#" + comment.substring(start, end) + "\r\n");
                start = end + 1;
                end = comment.indexOf(10, start);
            }
        }
    }

    private static void writeWorkspaceProject(Writer writer, String projectName, String projectFile, List<String> dependsOn) throws IOException {
        writer.write("############################################");
        writer.write("###################################\r\n\r\n");
        String file = projectFile;
        if (!(file.startsWith(".") || file.startsWith("\\") || file.startsWith("/"))) {
            file = ".\\" + file;
        }
        writer.write("Project: \"" + projectName + "\"=\"" + file + "\" - Package Owner=<4>\r\n\r\n");
        writer.write("Package=<5>\r\n{{{\r\n}}}\r\n\r\n");
        writer.write("Package=<4>\r\n{{{\r\n");
        if (dependsOn != null) {
            for (String string : dependsOn) {
                writer.write("    Begin Project Dependency\r\n");
                writer.write("    Project_Dep_Name " + MsvcProjectWriter.toProjectName(String.valueOf(string)) + "\r\n");
                writer.write("    End Project Dependency\r\n");
            }
        }
        writer.write("}}}\r\n\r\n");
    }

    public MsvcProjectWriter(String versionArg) {
        this.version = versionArg;
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Map<String, TargetInfo> targets) {
        for (TargetInfo targetInfo : targets.values()) {
            CommandLineCompilerConfiguration compilerConfig;
            ProcessorConfiguration config = targetInfo.getConfiguration();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof MsvcCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }

    private File[] getSources(List<File> sourceList) {
        File[] sortedSources = new File[sourceList.size()];
        sourceList.toArray(sortedSources);
        Arrays.sort(sortedSources, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedSources;
    }

    private boolean isGroupMember(String filter, File candidate) {
        String fileName = candidate.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < fileName.length() - 1) {
            String extension = ";" + fileName.substring(lastDot + 1).toLowerCase() + ";";
            String semiFilter = ";" + filter + ";";
            return semiFilter.contains(extension);
        }
        return false;
    }

    private void writeCompileOptions(Writer writer, boolean isDebug, String baseDir, CommandLineCompilerConfiguration compilerConfig) throws IOException {
        String[] preArgs;
        File[] includePath;
        StringBuffer baseOptions = new StringBuffer(50);
        baseOptions.append("# ADD BASE CPP");
        StringBuffer options = new StringBuffer(50);
        options.append("# ADD CPP");
        for (File element : includePath = compilerConfig.getIncludePath()) {
            options.append(" /I \"");
            String relPath = CUtil.getRelativePath(baseDir, element);
            options.append(CUtil.toWindowsPath(relPath));
            options.append('\"');
        }
        Hashtable<String, String> optionMap = new Hashtable<String, String>();
        if (isDebug) {
            optionMap.put("/MT", "/MTd");
            optionMap.put("/ML", "/MLd");
            optionMap.put("/MD", "/MDd");
            optionMap.put("/O2", "/Od");
            optionMap.put("/O3", "/Od");
        } else {
            optionMap.put("/MTD", "/MT");
            optionMap.put("/MLD", "/ML");
            optionMap.put("/MDD", "/MD");
            optionMap.put("/GM", "");
            optionMap.put("/ZI", "");
            optionMap.put("/OD", "/O2");
            optionMap.put("/GZ", "");
        }
        for (String preArg : preArgs = compilerConfig.getPreArguments()) {
            if (preArg.startsWith("/D")) {
                options.append(" /D ");
                baseOptions.append(" /D ");
                String body = preArg.substring(2);
                if (preArg.indexOf(61) >= 0) {
                    options.append(body);
                    baseOptions.append(body);
                    continue;
                }
                StringBuffer buf = new StringBuffer("\"");
                if ("NDEBUG".equals(body) || "_DEBUG".equals(body)) {
                    if (isDebug) {
                        buf.append("_DEBUG");
                    } else {
                        buf.append("NDEBUG");
                    }
                } else {
                    buf.append(body);
                }
                buf.append("\"");
                options.append(buf);
                baseOptions.append(buf);
                continue;
            }
            if (preArg.startsWith("/I")) continue;
            String option = preArg;
            String key = option.toUpperCase(Locale.US);
            if (optionMap.containsKey(key)) {
                option = (String)optionMap.get(key);
            }
            options.append(" ");
            options.append(option);
            baseOptions.append(" ");
            baseOptions.append(option);
        }
        baseOptions.append("\r\n");
        options.append("\r\n");
        writer.write(baseOptions.toString());
        writer.write(options.toString());
    }

    private void writeConfig(Writer writer, boolean isDebug, List<DependencyDef> dependencies, String basePath, CommandLineCompilerConfiguration compilerConfig, TargetInfo linkTarget, Map<String, TargetInfo> targets) throws IOException {
        writer.write("# PROP BASE Use_MFC 0\r\n");
        String configType = "Release";
        String configInt = "0";
        String configMacro = "NDEBUG";
        if (isDebug) {
            configType = "Debug";
            configInt = "1";
            configMacro = "_DEBUG";
        }
        writer.write("# PROP BASE Use_Debug_Libraries ");
        writer.write(configInt);
        writer.write("\r\n# PROP BASE Output_Dir \"");
        writer.write(configType);
        writer.write("\"\r\n");
        writer.write("# PROP BASE Intermediate_Dir \"");
        writer.write(configType);
        writer.write("\"\r\n");
        writer.write("# PROP BASE Target_Dir \"\"\r\n");
        writer.write("# PROP Use_MFC 0\r\n");
        writer.write("# PROP Use_Debug_Libraries ");
        writer.write(configInt);
        writer.write("\r\n# PROP Output_Dir \"");
        writer.write(configType);
        writer.write("\"\r\n");
        writer.write("# PROP Intermediate_Dir \"");
        writer.write(configType);
        writer.write("\"\r\n");
        writer.write("# PROP Target_Dir \"\"\r\n");
        this.writeCompileOptions(writer, isDebug, basePath, compilerConfig);
        writer.write("# ADD BASE MTL /nologo /D \"" + configMacro + "\" /mktyplib203 /o NUL /win32\r\n");
        writer.write("# ADD MTL /nologo /D \"" + configMacro + "\" /mktyplib203 /o NUL /win32\r\n");
        writer.write("# ADD BASE RSC /l 0x409 /d \"" + configMacro + "\"\r\n");
        writer.write("# ADD RSC /l 0x409 /d \"" + configMacro + "\"\r\n");
        writer.write("BSC32=bscmake.exe\r\n");
        writer.write("# ADD BASE BSC32 /nologo\r\n");
        writer.write("# ADD BSC32 /nologo\r\n");
        writer.write("LINK32=link.exe\r\n");
        this.writeLinkOptions(writer, isDebug, dependencies, basePath, linkTarget, targets);
    }

    private void writeLinkOptions(Writer writer, boolean isDebug, List<DependencyDef> dependencies, String basePath, TargetInfo linkTarget, Map<String, TargetInfo> targets) throws IOException {
        StringBuffer baseOptions = new StringBuffer(100);
        StringBuffer options = new StringBuffer(100);
        baseOptions.append("# ADD BASE LINK32");
        options.append("# ADD LINK32");
        ProcessorConfiguration config = linkTarget.getConfiguration();
        if (config instanceof CommandLineLinkerConfiguration) {
            String[] endArgs;
            String[] preArgs;
            File[] linkSources;
            CommandLineLinkerConfiguration linkConfig = (CommandLineLinkerConfiguration)config;
            for (File linkSource : linkSources = linkTarget.getAllSources()) {
                if (targets.get(linkSource.getName()) != null) continue;
                String relPath = linkSource.getName();
                boolean fromDependency = false;
                if (relPath.indexOf(".") > 0) {
                    String baseName = relPath.substring(0, relPath.indexOf("."));
                    for (DependencyDef depend : dependencies) {
                        if (baseName.compareToIgnoreCase(depend.getName()) != 0) continue;
                        fromDependency = true;
                    }
                }
                if (fromDependency) continue;
                if (!CUtil.isSystemPath(linkSource)) {
                    relPath = CUtil.getRelativePath(basePath, linkSource);
                }
                if (relPath.indexOf(32) > 0) {
                    options.append(" \"");
                    options.append(CUtil.toWindowsPath(relPath));
                    options.append("\"");
                    continue;
                }
                options.append(' ');
                options.append(CUtil.toWindowsPath(relPath));
            }
            for (String preArg : preArgs = linkConfig.getPreArguments()) {
                if (!isDebug && preArg.equals("/DEBUG")) continue;
                options.append(' ');
                options.append(preArg);
                baseOptions.append(' ');
                baseOptions.append(preArg);
            }
            for (String endArg : endArgs = linkConfig.getEndArguments()) {
                options.append(' ');
                options.append(endArg);
                baseOptions.append(' ');
                baseOptions.append(endArg);
            }
        }
        baseOptions.append("\r\n");
        options.append("\r\n");
        writer.write(baseOptions.toString());
        writer.write(options.toString());
    }

    private void writeMessage(Writer writer, String projectName, String targtype) throws IOException {
        writer.write("!MESSAGE This is not a valid makefile. ");
        writer.write("To build this project using NMAKE,\r\n");
        writer.write("!MESSAGE use the Export Makefile command and run\r\n");
        writer.write("!MESSAGE \r\n");
        writer.write("!MESSAGE NMAKE /f \"");
        writer.write(projectName);
        writer.write(".mak\".\r\n");
        writer.write("!MESSAGE \r\n");
        writer.write("!MESSAGE You can specify a configuration when running NMAKE\r\n");
        writer.write("!MESSAGE by defining the macro CFG on the command line. ");
        writer.write("For example:\r\n");
        writer.write("!MESSAGE \r\n");
        writer.write("!MESSAGE NMAKE /f \"");
        writer.write(projectName);
        writer.write(".mak\" CFG=\"");
        writer.write(projectName);
        writer.write(" - Win32 Debug\"\r\n");
        writer.write("!MESSAGE \r\n");
        writer.write("!MESSAGE Possible choices for configuration are:\r\n");
        writer.write("!MESSAGE \r\n");
        String pattern = "!MESSAGE \"{0} - Win32 {1}\" (based on \"{2}\")\r\n";
        writer.write(MessageFormat.format("!MESSAGE \"{0} - Win32 {1}\" (based on \"{2}\")\r\n", projectName, "Release", targtype));
        writer.write(MessageFormat.format("!MESSAGE \"{0} - Win32 {1}\" (based on \"{2}\")\r\n", projectName, "Debug", targtype));
        writer.write("!MESSAGE \r\n");
        writer.write("\r\n");
    }

    @Override
    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List<File> files, Map<String, TargetInfo> targets, TargetInfo linkTarget) throws IOException {
        String projectName = projectDef.getName();
        projectName = projectName != null ? MsvcProjectWriter.toProjectName(projectName) : MsvcProjectWriter.toProjectName(fileName.getName());
        String basePath = fileName.getAbsoluteFile().getParent();
        File dspFile = new File(fileName + ".dsp");
        if (!projectDef.getOverwrite() && dspFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + dspFile.toString());
        }
        File dswFile = new File(fileName + ".dsw");
        if (!projectDef.getOverwrite() && dswFile.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + dswFile.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to generate Visual Studio project when Microsoft C++ is not used.");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(dspFile));
        writer.write("# Microsoft Developer Studio Project File - Name=\"");
        writer.write(projectName);
        writer.write("\" - Package Owner=<4>\r\n");
        writer.write("# Microsoft Developer Studio Generated Build File, Format Version ");
        writer.write(this.version);
        writer.write("\r\n");
        writer.write("# ** DO NOT EDIT **\r\n\r\n");
        MsvcProjectWriter.writeComments(writer, projectDef.getComments());
        String outputType = task.getOuttype();
        String subsystem = task.getSubsystem();
        String targtype = "Win32 (x86) Dynamic-Link Library";
        String targid = "0x0102";
        if ("executable".equals(outputType)) {
            if ("console".equals(subsystem)) {
                targtype = "Win32 (x86) Console Application";
                targid = "0x0103";
            } else {
                targtype = "Win32 (x86) Application";
                targid = "0x0101";
            }
        } else if ("static".equals(outputType)) {
            targtype = "Win32 (x86) Static Library";
            targid = "0x0104";
        }
        writer.write("# TARGTYPE \"");
        writer.write(targtype);
        writer.write("\" ");
        writer.write(targid);
        writer.write("\r\n\r\nCFG=");
        writer.write(projectName + " - Win32 Debug");
        writer.write("\r\n");
        this.writeMessage(writer, projectName, targtype);
        writer.write("# Begin Project\r\n");
        if (this.version.equals("6.00")) {
            writer.write("# PROP AllowPerConfigDependencies 0\r\n");
        }
        writer.write("# PROP Scc_ProjName \"\"\r\n");
        writer.write("# PROP Scc_LocalPath \"\"\r\n");
        writer.write("CPP=cl.exe\r\n");
        writer.write("MTL=midl.exe\r\n");
        writer.write("RSC=rc.exe\r\n");
        writer.write("\r\n!IF  \"$(CFG)\" == \"" + projectName + " - Win32 Release\"\r\n");
        this.writeConfig(writer, false, projectDef.getDependencies(), basePath, compilerConfig, linkTarget, targets);
        writer.write("\r\n!ELSEIF  \"$(CFG)\" == \"" + projectName + " - Win32 Debug\"\r\n");
        this.writeConfig(writer, true, projectDef.getDependencies(), basePath, compilerConfig, linkTarget, targets);
        writer.write("\r\n!ENDIF\r\n");
        writer.write("# Begin Target\r\n\r\n");
        writer.write("# Name \"" + projectName + " - Win32 Release\"\r\n");
        writer.write("# Name \"" + projectName + " - Win32 Debug\"\r\n");
        File[] sortedSources = this.getSources(files);
        if (this.version.equals("6.00")) {
            String sourceFilter = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat";
            String headerFilter = "h;hpp;hxx;hm;inl";
            String resourceFilter = "ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe";
            writer.write("# Begin Group \"Source Files\"\r\n\r\n");
            writer.write("# PROP Default_Filter \"cpp;c;cxx;rc;def;r;odl;idl;hpj;bat\"\r\n");
            for (File sortedSource1 : sortedSources) {
                if (this.isGroupMember("h;hpp;hxx;hm;inl", sortedSource1) || this.isGroupMember("ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe", sortedSource1)) continue;
                this.writeSource(writer, basePath, sortedSource1);
            }
            writer.write("# End Group\r\n");
            writer.write("# Begin Group \"Header Files\"\r\n\r\n");
            writer.write("# PROP Default_Filter \"h;hpp;hxx;hm;inl\"\r\n");
            for (File sortedSource : sortedSources) {
                if (!this.isGroupMember("h;hpp;hxx;hm;inl", sortedSource)) continue;
                this.writeSource(writer, basePath, sortedSource);
            }
            writer.write("# End Group\r\n");
            writer.write("# Begin Group \"Resource Files\"\r\n\r\n");
            writer.write("# PROP Default_Filter \"ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe\"\r\n");
            for (File sortedSource : sortedSources) {
                if (!this.isGroupMember("ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe", sortedSource)) continue;
                this.writeSource(writer, basePath, sortedSource);
            }
            writer.write("# End Group\r\n");
        } else {
            for (File sortedSource : sortedSources) {
                this.writeSource(writer, basePath, sortedSource);
            }
        }
        writer.write("# End Target\r\n");
        writer.write("# End Project\r\n");
        ((Writer)writer).close();
        writer = new BufferedWriter(new FileWriter(dswFile));
        this.writeWorkspace(writer, projectDef, projectName, dspFile);
        ((Writer)writer).close();
    }

    private void writeSource(Writer writer, String basePath, File groupMember) throws IOException {
        writer.write("# Begin Source File\r\n\r\nSOURCE=");
        String relativePath = CUtil.getRelativePath(basePath, groupMember);
        if (!(relativePath.startsWith(".") || relativePath.contains(":") || relativePath.startsWith("\\"))) {
            relativePath = ".\\" + relativePath;
        }
        writer.write(CUtil.toWindowsPath(relativePath));
        writer.write("\r\n# End Source File\r\n");
    }

    private void writeWorkspace(Writer writer, ProjectDef project, String projectName, File dspFile) throws IOException {
        writer.write("Microsoft Developer Studio Workspace File, Format Version ");
        writer.write(this.version);
        writer.write("\r\n");
        writer.write("# WARNING: DO NOT EDIT OR DELETE");
        writer.write(" THIS WORKSPACE FILE!\r\n\r\n");
        MsvcProjectWriter.writeComments(writer, project.getComments());
        List<DependencyDef> dependencies = project.getDependencies();
        ArrayList<String> projectDeps = new ArrayList<String>();
        String basePath = dspFile.getParent();
        for (DependencyDef dep : dependencies) {
            if (dep.getFile() == null) continue;
            String projName = MsvcProjectWriter.toProjectName(dep.getName());
            projectDeps.add(projName);
            String depProject = CUtil.toWindowsPath(CUtil.getRelativePath(basePath, new File(dep.getFile() + ".dsp")));
            MsvcProjectWriter.writeWorkspaceProject(writer, projName, depProject, dep.getDependsList());
        }
        MsvcProjectWriter.writeWorkspaceProject(writer, projectName, dspFile.getName(), projectDeps);
        writer.write("############################################");
        writer.write("###################################\r\n\r\n");
        writer.write("Global:\r\n\r\nPackage=<5>\r\n{{{\r\n}}}");
        writer.write("\r\n\r\nPackage=<3>\r\n{{{\r\n}}}\r\n\r\n");
        writer.write("########################################");
        writer.write("#######################################\r\n\r\n");
    }
}

