/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.msvc.MsvcLinker;
import com.github.maven_nar.cpptasks.msvc.MsvcProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class MsvcResourceCompiler
extends CommandLineCompiler {
    private static final MsvcResourceCompiler instance = new MsvcResourceCompiler(false, null);
    private String identifier;

    public static MsvcResourceCompiler getInstance() {
        return instance;
    }

    private MsvcResourceCompiler(boolean newEnvironment, Environment env) {
        super("rc", null, new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".res", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("/D_DEBUG");
        } else {
            args.addElement("/DNDEBUG");
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new MsvcResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        MsvcProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    @Override
    public String getIdentifier() {
        return "Microsoft (R) Windows (R) Resource Compiler";
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return MsvcProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            String fullOutputName = new File(outputDir, outputFileName).toString();
            return "/fo" + fullOutputName;
        }
        return filename;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return MsvcLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 32000;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        MsvcProcessor.getUndefineSwitch(buffer, define);
    }
}

