/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.openwatcom;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.openwatcom.OpenWatcomCLinker;
import com.github.maven_nar.cpptasks.openwatcom.OpenWatcomProcessor;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.util.Vector;

public final class OpenWatcomLibrarian
extends CommandLineLinker {
    private static final OpenWatcomLibrarian INSTANCE = new OpenWatcomLibrarian();

    public static OpenWatcomLibrarian getInstance() {
        return INSTANCE;
    }

    private OpenWatcomLibrarian() {
        super("wlib", null, new String[]{".obj"}, new String[0], ".lib", false, null);
    }

    protected void addBase(long base, Vector<String> args) {
    }

    protected void addEntry(String entry, Vector<String> args) {
    }

    protected void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
    }

    protected void addIncremental(boolean incremental, Vector<String> args) {
    }

    protected void addMap(boolean map, Vector<String> args) {
    }

    protected void addStack(int stack, Vector<String> args) {
    }

    @Override
    protected String getCommandFileSwitch(String cmdFile) {
        return OpenWatcomProcessor.getCommandFileSwitch(cmdFile);
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return OpenWatcomProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return OpenWatcomCLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public String[] getOutputFileSwitch(String outFile) {
        return OpenWatcomProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    public boolean isCaseSensitive() {
        return OpenWatcomProcessor.isCaseSensitive();
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        outputFile.delete();
        super.link(task, outputFile, sourceFiles, config);
    }

    @Override
    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        StringBuffer buf = new StringBuffer();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement(this.quoteFilename(buf, outputFileName));
        for (String prearg : preargs) {
            execArgs.addElement(prearg);
        }
        int objBytes = 0;
        for (String sourceFile : sourceFiles) {
            String last4 = sourceFile.substring(sourceFile.length() - 4).toLowerCase();
            if (last4.equals(".def") || last4.equals(".res") || last4.equals(".lib")) continue;
            execArgs.addElement("+" + this.quoteFilename(buf, sourceFile));
            objBytes = (int)((long)objBytes + new File(sourceFile).length());
        }
        for (String endarg : endargs) {
            execArgs.addElement(endarg);
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        return execArguments;
    }
}

