/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.trolltech;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.gcc.LdLinker;
import com.github.maven_nar.cpptasks.parser.Parser;
import com.github.maven_nar.cpptasks.trolltech.UserInterfaceParser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class UserInterfaceCompiler
extends CommandLineCompiler {
    private static final UserInterfaceCompiler INSTANCE = new UserInterfaceCompiler(false, null);

    public static UserInterfaceCompiler getInstance() {
        return INSTANCE;
    }

    private UserInterfaceCompiler(boolean newEnvironment, Environment env) {
        super("uic", "-version", new String[]{".ui"}, new String[0], ".h", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) {
        BuildException exc = null;
        String[] thisSource = new String[1];
        String[] uicCommand = new String[args.length + endArgs.length + 4];
        uicCommand[0] = "uic";
        String[] uicImplCommand = new String[args.length + endArgs.length + 6];
        uicImplCommand[0] = "uic";
        String[] mocCommand = new String[args.length + endArgs.length + 4];
        mocCommand[0] = "moc";
        for (int i = 0; i < args.length; ++i) {
            uicCommand[i + 1] = args[i];
            uicImplCommand[i + 1] = args[i];
            mocCommand[i + i] = args[i];
        }
        uicCommand[args.length + 1] = "-o";
        uicImplCommand[args.length + 1] = "-o";
        mocCommand[args.length + 1] = "-o";
        int uicIndex = args.length + 4;
        int uicImplIndex = args.length + 6;
        int mocIndex = args.length + 4;
        for (String endArg : endArgs) {
            uicCommand[uicIndex++] = endArg;
            uicImplCommand[uicImplIndex++] = endArg;
            mocCommand[mocIndex++] = endArg;
        }
        for (String sourceFile : sourceFiles) {
            uicIndex = args.length + 2;
            uicImplIndex = args.length + 2;
            mocIndex = args.length + 2;
            String[] outputFileNames = this.getOutputFileNames(sourceFile, null);
            uicCommand[uicIndex++] = outputFileNames[0];
            uicCommand[uicIndex++] = sourceFile;
            uicImplCommand[uicImplIndex++] = outputFileNames[1];
            uicImplCommand[uicImplIndex++] = "-impl";
            uicImplCommand[uicImplIndex++] = outputFileNames[0];
            uicImplCommand[uicImplIndex++] = sourceFile;
            mocCommand[mocIndex++] = outputFileNames[2];
            mocCommand[mocIndex++] = outputFileNames[0];
            int retval = this.runCommand(task, outputDir, uicCommand);
            if (retval == 0 && (retval = this.runCommand(task, outputDir, uicImplCommand)) == 0) {
                retval = this.runCommand(task, outputDir, mocCommand);
            }
            if (monitor != null) {
                thisSource[0] = sourceFile;
                monitor.progress(thisSource);
            }
            if (retval == 0 || exc != null) continue;
            exc = new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
            if (relentless) continue;
            throw exc;
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    protected Parser createParser(File source) {
        return new UserInterfaceParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return "";
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        switch (index) {
            case 0: {
                return "-o";
            }
            case 1: {
                String outputFileName = this.getOutputFileNames(filename, null)[0];
                return new File(outputDir, outputFileName).toString();
            }
            case 2: {
                return filename;
            }
        }
        return null;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return LdLinker.getInstance();
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        String baseName = this.getBaseOutputName(inputFile);
        return new String[]{baseName + ".h", baseName + ".cpp", "moc_" + baseName + ".cpp"};
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

