/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

public class AOL {
    private String architecture;
    private String os;
    private String linkerName;

    public AOL(String aol) {
        int linkerIndex = 2;
        boolean osIndex = true;
        boolean architectureIndex = false;
        String[] aolString = aol.split("-", 3);
        switch (aolString.length) {
            case 3: {
                this.linkerName = aolString[2];
            }
            case 2: {
                this.os = aolString[1];
            }
            case 1: {
                this.architecture = aolString[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("AOL '" + aol + "' cannot be parsed.");
            }
        }
    }

    public AOL(String architecture, String os, String linkerName) {
        this.architecture = architecture;
        this.os = os;
        this.linkerName = linkerName;
    }

    public final String getKey() {
        String tempLinkerName = null;
        tempLinkerName = this.linkerName == null ? "" : (this.linkerName.equals("g++") ? ".gpp" : "." + this.linkerName);
        return this.architecture + (this.os == null ? "" : "." + this.os + tempLinkerName);
    }

    final String getOS() {
        return this.os;
    }

    public final boolean hasLinker(String linker) {
        return this.linkerName.equals(linker);
    }

    public final String toString() {
        String tempLinkerName = null;
        tempLinkerName = this.linkerName == null ? "" : (this.linkerName.equals("g++") ? "-gpp" : "-" + this.linkerName);
        return this.architecture + (this.os == null ? "" : "-" + this.os + tempLinkerName);
    }
}

